/* 
 * We are continuing to covert ME types to concrete tables. so add the new file 
 */
CREATE TABLE [Asset_Device] (
	[DeviceGuid] UNIQUEIDENTIFIER NOT NULL
	,[TimeLastAssetScan] DATETIME NOT NULL
	,[DateCreated] DATETIME NOT NULL
	,[DateModified] DATETIME NOT NULL
	,[OMRowVersion] TIMESTAMP NOT NULL
	,CONSTRAINT [Asset_Device_DeviceGuid_PK] PRIMARY KEY CLUSTERED ([DeviceGuid])
	,CONSTRAINT [Asset_Device_DeviceGuid_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device]([DeviceGuid])
	)
GO

CREATE TABLE [Asset_IBUAgent] (
	[DeviceGuid] [UNIQUEIDENTIFIER]	NOT NULL,
	[UserName] NVARCHAR(50) NULL,	
	[ComputerID] CHAR(4) NULL,	
	[AgentVersion] NVARCHAR(50) NULL,
	[DateCreated] [DATETIME] NOT NULL,
	[DateModified][DATETIME] NOT NULL,
	[OMRowVersion] TIMESTAMP NOT NULL,
    CONSTRAINT [Asset_IBUAgent_DeviceGuid_PK] PRIMARY KEY CLUSTERED ([DeviceGuid])
);
GO

ALTER TABLE [Asset_IBUAgent] WITH NOCHECK
	ADD CONSTRAINT [Asset_IBUAgent_DeviceGuid_Device_DeviceGuid_FK] FOREIGN KEY([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]);
GO

ALTER TABLE [dbo].[Asset_IBUAgent] WITH CHECK CHECK CONSTRAINT [Asset_IBUAgent_DeviceGuid_Device_DeviceGuid_FK];
GO