﻿CREATE TABLE [MonitorAttribute_temp](
    [MonitorID]				int               NOT NULL,
    [Name]					nvarchar(200)     NOT NULL,
    [TextValue]				nvarchar(1000)    NULL,
    [NumericValue]			float             NULL,
    [BinaryValue]			image             NULL,
    [MonitoredObjectGuid]   uniqueidentifier    NOT NULL,
    [MonitoredObjectType]   nvarchar(50)        NOT NULL
)
go


insert MonitorAttribute_temp
(
     [MonitorID]					
    ,[Name]						
    ,[TextValue]					
    ,[NumericValue]				
    ,[BinaryValue]				
    ,[MonitoredObjectGuid]		
    ,[MonitoredObjectType]		
)
select      
     [MonitorID]					
    ,[Name]						
    ,[TextValue]					
    ,[NumericValue]				
    ,[BinaryValue]				
    ,[MonitoredObjectGuid]		
    ,[MonitoredObjectType]		
from 
     MonitorAttribute
go

drop table MonitorAttribute
go	

CREATE TABLE [MonitorAttribute](
    [MonitorID]     int               NOT NULL,
    [Name]          nvarchar(200)     NOT NULL,
    [TextValue]     nvarchar(1000)    NULL,
    [NumericValue]  float             NULL,
    [BinaryValue]   image             NULL,
    [MonitoredObjectGuid]  uniqueidentifier    NOT NULL,
    [MonitoredObjectType]  nvarchar(50)        NOT NULL,
    CONSTRAINT [PK_MonitorAttribute] PRIMARY KEY ([MonitoredObjectGuid], [MonitoredObjectType], [MonitorID], [Name]), 
    CONSTRAINT [FK_MonitorAttribute_Monitor] FOREIGN KEY ([MonitoredObjectGuid], [MonitoredObjectType], [MonitorID])
    REFERENCES [Monitor]([MonitoredObjectGuid], [MonitoredObjectType], [MonitorID])
)
go
CREATE INDEX [MonitorAttribute_MonitorID_IX] ON [MonitorAttribute]([MonitorID])
go


insert MonitorAttribute
(
     [MonitorID]					
    ,[Name]						
    ,[TextValue]					
    ,[NumericValue]				
    ,[BinaryValue]				
    ,[MonitoredObjectGuid]		
    ,[MonitoredObjectType]		
)
select      
     [MonitorID]					
    ,[Name]						
    ,[TextValue]					
    ,[NumericValue]				
    ,[BinaryValue]				
    ,[MonitoredObjectGuid]		
    ,[MonitoredObjectType]		
from 
     MonitorAttribute_temp
go

drop table MonitorAttribute_temp
go