﻿CREATE TABLE Asset_Software(
    [SoftwareAssetGuid]     UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]            UNIQUEIDENTIFIER NOT NULL,
    [Name]                  NVARCHAR (200)   NOT NULL,
    [Version]               NVARCHAR (100)   NULL,
    [Vendor]                NVARCHAR (100)   NULL,
    [InstallDate]           DATETIME         NULL,
    [InstallLocation]       NVARCHAR (4000)   NULL,
    [InstallSource]         NVARCHAR (256)   NULL,
    [ProductLanguage]       NVARCHAR (30)    NULL,
    [LocalPackage]          NVARCHAR (150)   NULL,
    [PackageCode]           NVARCHAR (255)    NULL,
    [PackageName]           NVARCHAR (255)   NULL,
    [RegisteredOwner]       NVARCHAR (50)    NULL,
    [ProductID]             NVARCHAR (50)    NULL,
    [RegisteredCompany]     NVARCHAR (50)    NULL,
    [TimesUsed]             NVARCHAR (5)     NULL,
    [LastUsed]              NVARCHAR (22)    NULL,
    [ExecutablePath]        NVARCHAR (130)   NULL,
    [SoftwareID]            NVARCHAR (10)    NULL,
    [ExecutableDescription] NVARCHAR (50)    NULL,
    [ExecutableVersion]     NVARCHAR (50)    NULL,
    [AssignmentType]        NVARCHAR (50)    NULL,
    [InstallState]          NVARCHAR (50)    NULL,
    [DateCreated]           DATETIME         NOT NULL,
    [DateModified]          DATETIME         NOT NULL,	
    [OMRowVersion]          rowversion       NOT NULL,
	CONSTRAINT [PK_Asset_Software_SoftwareAssetGuid] PRIMARY KEY NONCLUSTERED ( [SoftwareAssetGuid] ),
    CONSTRAINT [Asset_Software_Device_FK] FOREIGN KEY              ([DeviceGuid])            REFERENCES [Device] ([DeviceGuid])
);
go

create nonclustered index Asset_Software_DeviceGuid_IX on Asset_Software(DeviceGuid) 
go

create unique nonclustered index Asset_Software_SoftwareAssetGuid_IX 
		on Asset_Software(SoftwareAssetGuid)  
go




CREATE TABLE [Asset_Win32_Service]
(
		 [Win32_ServiceGuid]   UNIQUEIDENTIFIER NOT NULL
		,[DeviceGuid]          UNIQUEIDENTIFIER NOT NULL
        ,[Name]                nvarchar(255)    NOT NULL
        ,[Caption]             nvarchar(255)        NULL
        ,[CheckPoint]          bigint               NULL
        ,[CreationClassName]   nvarchar(50)        NULL
        ,[Description]         nvarchar(2000)        NULL
        ,[DesktopInteract]     bit                  NULL
        ,[DisplayName]         nvarchar(255)        NULL
        ,[ErrorControl]        nvarchar(50)        NULL
        ,[ExitCode]            bigint               NULL
        ,[InstallDate]         datetime             NULL
        ,[PathName]            nvarchar(4000)       NULL
        ,[ProcessId]           bigint               NULL
        ,[ServiceSpecificExitCode]          bigint  NULL
        ,[ServiceType]         nvarchar(50)        NULL
        ,[Started]             bit                  NULL
        ,[StartMode]           nvarchar(50)        NULL
        ,[StartName]           nvarchar(255)        NULL
        ,[State]               nvarchar(50)        NULL 
        ,[Status]              nvarchar(50)        NULL
        ,[SystemCreationClassName]    nvarchar(50) NULL
        ,[SystemName]          nvarchar(50)        NULL
        ,[TagId]               bigint               NULL
        ,[WaitHint]            bigint               null
		,[DateCreated]           DATETIME         NOT NULL
		,[DateModified]          DATETIME         NOT NULL
        ,[OMRowVersion]         rowversion        NOT NULL
		,CONSTRAINT [PK_Asset_Win32_Service_Win32_ServiceGuid] PRIMARY KEY ( [Win32_ServiceGuid] )
        ,CONSTRAINT [Asset_Win32_Service_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
)
go

create nonclustered index Asset_Win32_Service_DeviceGuid_IX on Asset_Win32_Service(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_Service_Win32_ServiceGuid_UX 
		on Asset_Win32_Service(Win32_ServiceGuid)  
go

CREATE TABLE [Asset_Win32_QuickFixEngineering]
(
     [Win32_QuickFixEngineeringGuid]               UNIQUEIDENTIFIER NOT NULL
    ,[DeviceGuid]                 UNIQUEIDENTIFIER NOT NULL
    ,[Caption]                    nvarchar(200)        null      
    ,[CSName]                     nvarchar(100)        null 
    ,[Description]                nvarchar(500)        null 
    ,[FixComments]                nvarchar(200)        null 
    ,[HotFixID]                   nvarchar(260)    not null
    ,[InstallDate]                datetime             null 
    ,[InstalledBy]                nvarchar(100)        null 
    ,[InstalledOn]                nvarchar(100)        null 
    ,[Name]                       nvarchar(200)        null 
    ,[ServicePackInEffect]        nvarchar(100)        null 
    ,[Status]                     nvarchar(100)       null 
    ,[DateCreated]                DATETIME         NOT NULL
    ,[DateModified]               DATETIME         NOT NULL
    ,[OMRowVersion]               rowversion       NOT NULL
	,CONSTRAINT [PK_Asset_Win32_QuickFixEngineering_Win32_QuickFixEngineeringGuid] PRIMARY KEY NONCLUSTERED( [Win32_QuickFixEngineeringGuid] )
    ,CONSTRAINT [Asset_Win32_QuickFixEngineering_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
);
go

create nonclustered index Asset_Win32_QuickFixEngineering_DeviceGuid_IX on Asset_Win32_QuickFixEngineering(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_QuickFixEngineering_Win32_QuickFixEngineeringGuid_UX 
	on Asset_Win32_QuickFixEngineering(Win32_QuickFixEngineeringGuid) 
go

CREATE TABLE [Asset_Win32_BaseBoard] 
(
	[Win32_BaseBoardGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[Caption]				NVARCHAR(500)		NULL,
	[ConfigOptions]			NVARCHAR(3000)		NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[Depth]					REAL				NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[Height]				REAL				NULL,
	[HostingBoard]			BIT					NULL,
	[HotSwappable]			BIT					NULL,
	[InstallDate]			DATETIME			NULL,
	[Manufacturer]			NVARCHAR(1000)		NULL,
	[Model]					NVARCHAR(1000)		NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[OtherIdentifyingInfo]	NVARCHAR(1000)		NULL,
	[PartNumber]			NVARCHAR(1000)		NULL,
	[PoweredOn]				BIT					NULL,
	[Product]				NVARCHAR(1000)		NULL,
	[Removable]				BIT					NULL,
	[Replaceable]			BIT					NULL,
	[RequirementsDescription]	NVARCHAR(2000)	NULL,
	[RequiresDaughterBoard]	BIT					NULL,
	[SerialNumber]			NVARCHAR(1000)		NULL,
	[SKU]					NVARCHAR(1000)		NULL,
	[SlotLayout]			NVARCHAR(1000)		NULL,
	[SpecialRequirements]	BIT					NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[Tag]					NVARCHAR(1000)		NULL,
	[Version]				NVARCHAR(1000)		NULL,
	[Weight]				REAL				NULL,
	[Width]					REAL				NULL,

	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_BaseBoard_Win32_BaseBoardGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_BaseBoardGuid]),
	CONSTRAINT [Asset_Win32_BaseBoard_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO

create nonclustered index Asset_Win32_BaseBoard_DeviceGuid_IX on Asset_Win32_BaseBoard(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_BaseBoard_Win32_BaseBoardGuid_UX 
	on Asset_Win32_BaseBoard(Win32_BaseBoardGuid) 
go


CREATE TABLE [Asset_Win32_Bios] 
(
	[Win32_BiosGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[BiosCharacteristics]		NVARCHAR(3000)	NULL,
	[BIOSVersion]				NVARCHAR(3000)	NULL,
	[BuildNumber]				NVARCHAR(1000)	NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[CodeSet]					NVARCHAR(1000)	NULL,
	[CurrentLanguage]			NVARCHAR(1000)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[EmbeddedControllerMajorVersion]	SMALLINT	NULL,
	[EmbeddedControllerMinorVersion]	SMALLINT	NULL,
	[IdentificationCode]		NVARCHAR(1000)	NULL,
	[InstallableLanguages]		INT				NULL,
	[InstallDate]				DATETIME		NULL,
	[LanguageEdition]			NVARCHAR(1000)	NULL,
	[ListOfLanguages]			NVARCHAR(3000)	NULL,
	[Manufacturer]				NVARCHAR(1000)	NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[OtherTargetOS]				NVARCHAR(1000)	NULL,
	[PrimaryBIOS]				BIT				NULL,
	[ReleaseDate]				DATETIME		NULL,
	[SerialNumber]				NVARCHAR(1000)	NULL,
	[SMBIOSBIOSVersion]			NVARCHAR(1000)	NULL,
	[SMBIOSMajorVersion]		INT				NULL,
	[SMBIOSMinorVersion]		INT				NULL,
	[SMBIOSPresent]				BIT				NULL,
	[SoftwareElementID]			NVARCHAR(1000)	NULL,
	[SoftwareElementState]		INT				NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[SystemBiosMajorVersion]	SMALLINT		NULL,
	[SystemBiosMinorVersion]	SMALLINT		NULL,
	[TargetOperatingSystem]		INT				NULL,
	[Version]					NVARCHAR(1000)	NULL,
	
	
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_Bios_Win32_BiosGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_BiosGuid]),
	CONSTRAINT [Asset_Win32_Bios_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO

create nonclustered index Asset_Win32_Bios_DeviceGuid_IX on Asset_Win32_Bios(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_Bios_Win32_BiosGuid_UX 
	on Asset_Win32_Bios(Win32_BiosGuid) 
go


CREATE TABLE [Asset_Win32_ComputerSystem] 
(
	[Win32_ComputerSystemGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]				UNIQUEIDENTIFIER	NOT NULL, 
	[AdminPasswordStatus]		INT					NULL,
	[AutomaticManagedPagefile]	BIT				NULL,
	[AutomaticResetBootOption]	BIT				NULL,
	[AutomaticResetCapability]	BIT				NULL,
	[BootOptionOnLimit]			INT				NULL,
	[BootOptionOnWatchDog]		INT				NULL,
	[BootROMSupported]			BIT				NULL,
	[BootupState]				NVARCHAR(1000)	NULL,
	[BootStatus]				NVARCHAR(3000)	NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[ChassisBootupState]		INT				NULL,
	[ChassisSKUNumber]			NVARCHAR(1000)	NULL,
	[CreationClassName]			NVARCHAR(1000)	NULL,
	[CurrentTimeZone]			SMALLINT		NULL,
	[DaylightInEffect]			BIT				NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[DNSHostName]				NVARCHAR(1000)	NULL,
	[Domain]					NVARCHAR(1000)	NULL,
	[DomainRole]				INT				NULL,
	[EnableDaylightSavingsTime]	BIT				NULL,
	[FrontPanelResetStatus]		INT				NULL,
	[HypervisorPresent]			BIT				NULL,
	[InfraredSupported]			BIT				NULL,
	[InitialLoadInfo]			NVARCHAR(3000)	NULL,
	[InstallDate]				DATETIME		NULL,
	[KeyboardPasswordStatus]	INT				NULL,
	[LastLoadInfo]				NVARCHAR(1000)	NULL,
	[Manufacturer]				NVARCHAR(1000)	NULL,
	[Model]						NVARCHAR(1000)	NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[NameFormat]				NVARCHAR(1000)	NULL,
	[NetworkServerModeEnabled]	BIT				NULL,
	[NumberOfLogicalProcessors]	BIGINT			NULL,
	[NumberOfProcessors]		BIGINT			NULL,
	[OEMLogoBitmap]				NVARCHAR(3000)	NULL,
	[OEMStringArray]			NVARCHAR(3000)	NULL,
	[PartOfDomain]				BIT				NULL,
	[PauseAfterReset]			BIGINT			NULL,
	[PCSystemType]				INT				NULL,
	[PCSystemTypeEx]			INT				NULL,
	[PowerManagementCapabilities]NVARCHAR(3000)	NULL,
	[PowerManagementSupported]	BIT				NULL,
	[PowerOnPasswordStatus]		INT				NULL,
	[PowerState]				INT				NULL,
	[PowerSupplyState]			INT				NULL,
	[PrimaryOwnerContact]		NVARCHAR(1000)	NULL,
	[PrimaryOwnerName]			NVARCHAR(1000)	NULL,
	[ResetCapability]			INT				NULL,
	[ResetCount]				SMALLINT		NULL,
	[ResetLimit]				SMALLINT		NULL,
	[Roles]						NVARCHAR(3000)	NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[SupportContactDescription]	NVARCHAR(3000)	NULL,
	[SystemFamily]				NVARCHAR(1000)	NULL,
	[SystemSKUNumber]			NVARCHAR(1000)	NULL,
	[SystemStartupDelay]		INT				NULL,
	[SystemStartupOptions]		NVARCHAR(1000)	NULL,
	[SystemStartupSetting]		SMALLINT		NULL,
	[SystemType]				NVARCHAR(1000)	NULL,
	[ThermalState]				INT				NULL,
	[TotalPhysicalMemory]		BIGINT			NULL,
	[UserName]					NVARCHAR(1000)	NULL,
	[WakeUpType]				INT				NULL,
	[Workgroup]					NVARCHAR(1000)	NULL,

	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_ComputerSystem_Win32_ComputerSystemGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_ComputerSystemGuid]),
	CONSTRAINT [Asset_Win32_ComputerSystem_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO

create nonclustered index Asset_Win32_ComputerSystem_DeviceGuid_IX on Asset_Win32_ComputerSystem(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_ComputerSystem_Win32_ComputerSystemGuid_UX 
	on Asset_Win32_ComputerSystem(Win32_ComputerSystemGuid) 
go



CREATE TABLE [Asset_Win32_DiskDrive] 
(
	[Win32_DiskDriveGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
    [DeviceID]			NVARCHAR(2000)		NULL, 
	[Availability]			INT					NULL,
	[BytesPerSector]		BIGINT				NULL,
	[Capabilities]			NVARCHAR(3000)		NULL,
	[CapabilityDescriptions]NVARCHAR(3000)		NULL,
	[Caption]				NVARCHAR(500)		NULL,
	[CompressionMethod]		NVARCHAR(1000)		NULL,
	[ConfigManagerErrorCode]NVARCHAR(1000)		NULL,
	[ConfigManagerUserConfig]	BIT				NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[DefaultBlockSize]		BIGINT				NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[ErrorCleared]			BIT					NULL,
	[ErrorDescription]		NVARCHAR(2000)		NULL,
	[ErrorMethodology]		NVARCHAR(1000)		NULL,
	[FirmwareRevision]		NVARCHAR(1000)		NULL,
	[Index]					BIGINT				NULL,
	[InstallDate]			DATETIME			NULL,
	[InterfaceType]			NVARCHAR(1000)		NULL,
	[LastErrorCode]			BIGINT				NULL,
	[Manufacturer]			NVARCHAR(1000)		NULL,
	[MaxBlockSize]			BIGINT				NULL,
	[MaxMediaSize]			BIGINT				NULL,
	[MediaLoaded]			BIT					NULL,
	[MediaType]				NVARCHAR(1000)		NULL,
	[MinBlockSize]			BIGINT				NULL,
	[Model]					NVARCHAR(1000)		NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[NeedsCleaning]			BIT					NULL,
	[NumberOfMediaSupported]BIGINT				NULL,
	[Partitions]			BIGINT				NULL,
	[PNPDeviceID]			NVARCHAR(1000)		NULL,
	[PowerManagementCapabilities]	NVARCHAR(3000)			NULL,
	[PowerManagementSupported]	BIT				NULL,
	[SCSIBus]				BIGINT				NULL,
	[SCSILogicalUnit]		INT					NULL,
	[SCSIPort]				INT					NULL,
	[SCSITargetId]			INT					NULL,
	[SectorsPerTrack]		BIGINT				NULL,
	[SerialNumber]			NVARCHAR(1000)		NULL,
	[Signature]				BIGINT				NULL,
	[Size]					BIGINT				NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[StatusInfo]			INT					NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]			NVARCHAR(1000)		NULL,
	[TotalCylinders]		BIGINT				NULL,
	[TotalHeads]			BIGINT				NULL,
	[TotalSectors]			BIGINT				NULL,
	[TotalTracks]			BIGINT				NULL,
	[TracksPerCylinder]		BIGINT				NULL,

	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_DiskDrive_Win32_DiskDriveGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_DiskDriveGuid]),
	CONSTRAINT [Asset_Win32_DiskDrive_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO

create nonclustered index Asset_Win32_DiskDrive_DeviceGuid_IX on Asset_Win32_DiskDrive(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_DiskDrive_Win32_DiskDriveGuid_UX 
	on Asset_Win32_DiskDrive(Win32_DiskDriveGuid) 
go


CREATE TABLE [Asset_Win32_LogicalDisk] 
(
	[Win32_LogicalDiskGuid] UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
    [DeviceID]			NVARCHAR(2000)		NULL, 
	[Access]				INT					NULL,
	[Availability]			INT					NULL,
	[BlockSize]				BIGINT				NULL,
	[Caption]				NVARCHAR(500)		NULL,
	[Compressed]			BIT					NULL,
	[ConfigManagerErrorCode]	BIGINT			NULL,
	[ConfigManagerUserConfig]	BIT				NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[DriveType]				BIGINT				NULL,
	[ErrorCleared]			BIT					NULL,
	[ErrorDescription]		NVARCHAR(2000)		NULL,
	[ErrorMethodology]		NVARCHAR(1000)		NULL,
	[FileSystem]			NVARCHAR(1000)		NULL,
	[FreeSpace]				BIGINT				NULL,
	[InstallDate]			DATETIME			NULL,
	[LastErrorCode]			BIGINT				NULL,
	[MaximumComponentLength]	BIGINT			NULL,
	[MediaType]				BIGINT				NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[NumberOfBlocks]		BIGINT				NULL,
	[PNPDeviceID]			NVARCHAR(1000)		NULL,
	[PowerManagementCapabilities]	NVARCHAR(3000)			NULL,
	[PowerManagementSupported]	BIT				NULL,
	[ProviderName]			NVARCHAR(1000)		NULL,
	[Purpose]				NVARCHAR(2000)		NULL,
	[QuotasDisabled]		BIT					NULL,
	[QuotasIncomplete]		BIT					NULL,
	[QuotasRebuilding]		BIT					NULL,
	[Size]					BIGINT				NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[StatusInfo]			INT					NULL,
	[SupportsDiskQuotas]	BIT					NULL,
	[SupportsFileBasedCompression]	BIT			NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]			NVARCHAR(1000)		NULL,
	[VolumeDirty]			BIT					NULL,
	[VolumeName]			NVARCHAR(1000)		NULL,
	[VolumeSerialNumber]	NVARCHAR(1000)		NULL,
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_LogicalDisk_Win32_LogicalDiskGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_LogicalDiskGuid]),
	CONSTRAINT [Asset_Win32_LogicalDisk_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO

create nonclustered index Asset_Win32_LogicalDisk_DeviceGuid_IX on Asset_Win32_LogicalDisk(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_LogicalDisk_Win32_LogicalDiskGuid_UX 
	on Asset_Win32_LogicalDisk(Win32_LogicalDiskGuid) 
go


CREATE TABLE [Asset_Win32_MotherBoardDevice] 
(
	[Win32_MotherBoardDeviceGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	
	[Availability]				INT				NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[ConfigManagerErrorCode]	BIGINT			NULL,
	[ConfigManagerUserConfig]	BIT				NULL,
	[CreationClassName]			NVARCHAR(1000)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[DeviceID]				NVARCHAR(1000)	NULL,
	[ErrorCleared]				BIT				NULL,
	[ErrorDescription]			NVARCHAR(2000)	NULL,
	[InstallDate]				DATETIME		NULL,
	[LastErrorCode]				BIGINT			NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[PNPDeviceID]				NVARCHAR(1000)	NULL,
	[PowerManagementCapabilities]NVARCHAR(3000)	NULL,
	[PowerManagementSupported]	BIT				NULL,
	[PrimaryBusType]			NVARCHAR(1000)	NULL,
	[RevisionNumber]			NVARCHAR(1000)	NULL,
	[SecondaryBusType]			NVARCHAR(1000)	NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[StatusInfo]				INT				NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]				NVARCHAR(1000)	NULL,
	
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_MotherBoardDevice_Win32_MotherBoardDeviceGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_MotherBoardDeviceGuid]),
	CONSTRAINT [Asset_Win32_MotherBoardDevice_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO

create nonclustered index Asset_Win32_MotherBoardDevice_DeviceGuid_IX on Asset_Win32_MotherBoardDevice(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_MotherBoardDevice_Win32_MotherBoardDeviceGuid_UX 
	on Asset_Win32_MotherBoardDevice(Win32_MotherBoardDeviceGuid) 
go



CREATE TABLE [Asset_Win32_NetworkAdapter] 
(
	[Win32_NetworkAdapterGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[AdapterType]				NVARCHAR(1000)	NULL,
	[AdapterTypeId]				INT				NULL,
	[AutoSense]					BIT				NULL,
	[Availability]				INT				NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[ConfigManagerErrorCode]	BIGINT			NULL,
	[ConfigManagerUserConfig]	BIT				NULL,
	[CreationClassName]			NVARCHAR(1000)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[DeviceID]				NVARCHAR(1000)	NULL,
	[ErrorCleared]				BIT				NULL,
	[ErrorDescription]			NVARCHAR(2000)	NULL,
	[GUID]						NVARCHAR(1000)	NULL,
	[Index]						BIGINT			NULL,
	[InstallDate]				DATETIME		NULL,
	[Installed]					BIT				NULL,
	[InterfaceIndex]			BIGINT			NULL,
	[LastErrorCode]				BIGINT			NULL,
	[MACAddress]				NVARCHAR(1000)	NULL,
	[Manufacturer]				NVARCHAR(1000)	NULL,
	[MaxNumberControlled]		BIGINT			NULL,
	[MaxSpeed]					BIGINT			NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[NetConnectionID]			NVARCHAR(1000)	NULL,
	[NetConnectionStatus]		INT				NULL,
	[NetEnabled]				BIT				NULL,
	[NetworkAddresses]			NVARCHAR(3000)	NULL,
	[PermanentAddress]			NVARCHAR(1000)	NULL,
	[PhysicalAdapter]			BIT				NULL,
	[PNPDeviceID]				NVARCHAR(1000)	NULL,
	[PowerManagementCapabilities]	NVARCHAR(3000)	NULL,
	[PowerManagementSupported]	BIT				NULL,
	[ProductName]				NVARCHAR(1000)	NULL,
	[ServiceName]				NVARCHAR(1000)	NULL,
	[Speed]						DECIMAL(20)			NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[StatusInfo]				INT				NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]				NVARCHAR(1000)	NULL,
	[TimeOfLastReset]			DATETIME		NULL,


	
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_NetworkAdapter_Win32_NetworkAdapterGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_NetworkAdapterGuid]),
	CONSTRAINT [Asset_Win32_NetworkAdapter_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO

create nonclustered index Asset_Win32_NetworkAdapter_DeviceGuid_IX on Asset_Win32_NetworkAdapter(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_NetworkAdapter_Win32_NetworkAdapterGuid_UX 
	on Asset_Win32_NetworkAdapter(Win32_NetworkAdapterGuid) 
go


CREATE TABLE [Asset_Win32_OperatingSystem] 
(
	[Win32_OperatingSystemGuid] UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[BootDevice]			NVARCHAR(1000)		NULL,
	[BuildNumber]			NVARCHAR(1000)		NULL,
	[BuildType]				NVARCHAR(1000)		NULL,
	[Caption]				NVARCHAR(500)		NULL,
	[CodeSet]				NVARCHAR(1000)		NULL,
	[CountryCode]			NVARCHAR(1000)		NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[CSCreationClassName]	NVARCHAR(1000)		NULL,
	[CSDVersion]			NVARCHAR(1000)		NULL,
	[CSName]				NVARCHAR(1000)		NULL,
	[CurrentTimeZone]		SMALLINT			NULL,
	[DataExecutionPrevention_Available]	BIT		NULL,
	[DataExecutionPrevention_32BitApplications]	BIT	NULL,
	[DataExecutionPrevention_Drivers]	BIT		NULL,
	[DataExecutionPrevention_SupportPolicy]	SMALLINT	NULL,
	[Debug]					BIT					NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[Distributed]			BIT					NULL,
	[EncryptionLevel]		BIGINT				NULL,
	[ForegroundApplicationBoost]	SMALLINT	NULL,
	[FreePhysicalMemory]	BIGINT				NULL,
	[FreeSpaceInPagingFiles]BIGINT				NULL,
	[FreeVirtualMemory]		BIGINT				NULL,
	[InstallDate]			DATETIME			NULL,
	[LargeSystemCache]		BIGINT				NULL,
	[LastBootUpTime]		DATETIME			NULL,
	[LocalDateTime]			DATETIME			NULL,
	[Locale]				NVARCHAR(1000)		NULL,
	[Manufacturer]			NVARCHAR(1000)		NULL,
	[MaxNumberOfProcesses]	BIGINT				NULL,
	[MaxProcessMemorySize]	BIGINT				NULL,
	[MUILanguages]			NVARCHAR(3000)		NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[NumberOfLicensedUsers]	BIGINT				NULL,
	[NumberOfProcesses]		BIGINT				NULL,
	[NumberOfUsers]			BIGINT				NULL,
	[OperatingSystemSKU]	BIGINT				NULL,
	[Organization]			NVARCHAR(1000)		NULL,
	[OSArchitecture]		NVARCHAR(1000)		NULL,
	[OSLanguage]			BIGINT				NULL,
	[OSProductSuite]		BIGINT				NULL,
	[OSType]				INT					NULL,
	[OtherTypeDescription]	NVARCHAR(2000)		NULL,
	[PAEEnabled]			BIT					NULL,
	[PlusProductID]			NVARCHAR(1000)		NULL,
	[PlusVersionNumber]		NVARCHAR(1000)		NULL,
	[PortableOperatingSystem]	BIT				NULL,
	[Primary]				BIT					NULL,
	[ProductType]			BIGINT				NULL,
	[RegisteredUser]		NVARCHAR(1000)		NULL,
	[SerialNumber]			NVARCHAR(1000)		NULL,
	[ServicePackMajorVersion]	INT				NULL,
	[ServicePackMinorVersion]	INT				NULL,
	[SizeStoredInPagingFiles]	BIGINT			NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[SuiteMask]				BIGINT				NULL,
	[SystemDevice]			NVARCHAR(1000)		NULL,
	[SystemDirectory]		NVARCHAR(1000)		NULL,
	[SystemDrive]			NVARCHAR(1000)		NULL,
	[TotalSwapSpaceSize]	BIGINT				NULL,
	[TotalVirtualMemorySize]	BIGINT			NULL,
	[TotalVisibleMemorySize]	BIGINT			NULL,
	[Version]				NVARCHAR(1000)		NULL,
	[WindowsDirectory]		NVARCHAR(1000)		NULL,
	[QuantumLength]			SMALLINT			NULL,
	[QuantumType]			SMALLINT			NULL,

	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_OperatingSystem_Win32_OperatingSystemGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_OperatingSystemGuid]),
	CONSTRAINT [Asset_Win32_OperatingSystem_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO

create nonclustered index Asset_Win32_OperatingSystem_DeviceGuid_IX on Asset_Win32_OperatingSystem(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_OperatingSystem_Win32_OperatingSystemGuid_UX 
	on Asset_Win32_OperatingSystem(Win32_OperatingSystemGuid) 
go



CREATE TABLE [Asset_Win32_NetworkAdapterConfiguration] 
(
	[Win32_NetworkAdapterConfigurationGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	
	
	[Caption]					NVARCHAR(500)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[SettingID]					NVARCHAR(1000)	NULL,
	[ArpAlwaysSourceRoute]		BIT				NULL,
	[ArpUseEtherSNAP]			BIT				NULL,
	[DatabasePath]				NVARCHAR(1000)	NULL,
	[DeadGWDetectEnabled]		BIT				NULL,
	[DefaultIPGateway]			NVARCHAR(3000)	NULL,
	[DefaultTOS]				SMALLINT		NULL,
	[DefaultTTL]				SMALLINT		NULL,
	[DHCPEnabled]				BIT				NULL,
	[DHCPLeaseExpires]			DATETIME		NULL,
	[DHCPLeaseObtained]			DATETIME		NULL,
	[DHCPServer]				NVARCHAR(1000)	NULL,
	[DNSDomain]					NVARCHAR(1000)	NULL,
	[DNSDomainSuffixSearchOrder]NVARCHAR(3000)	NULL,
	[DNSEnabledForWINSResolution]	BIT			NULL,
	[DNSHostName]				NVARCHAR(1000)	NULL,
	[DNSServerSearchOrder]		NVARCHAR(3000)	NULL,
	[DomainDNSRegistrationEnabled]	BIT			NULL,
	[ForwardBufferMemory]		BIGINT			NULL,
	[FullDNSRegistrationEnabled]	BIT			NULL,
	[GatewayCostMetric]			NVARCHAR(3000)	NULL,
	[IGMPLevel]					SMALLINT		NULL,
	[Index]						BIGINT			NULL,
	[InterfaceIndex]			BIGINT			NULL,
	[IPAddress]					NVARCHAR(3000)	NULL,
	[IPConnectionMetric]		BIGINT			NULL,
	[IPEnabled]					BIT				NULL,
	[IPFilterSecurityEnabled]	BIT				NULL,
	[IPPortSecurityEnabled]		BIT				NULL,
	[IPSecPermitIPProtocols]	NVARCHAR(3000)	NULL,
	[IPSecPermitTCPPorts]		NVARCHAR(3000)	NULL,
	[IPSecPermitUDPPorts]		NVARCHAR(3000)	NULL,
	[IPSubnet]					NVARCHAR(3000)	NULL,
	[IPUseZeroBroadcast]		BIT				NULL,
	[IPXAddress]				NVARCHAR(1000)	NULL,
	[IPXEnabled]				BIT				NULL,
	[IPXFrameType]				NVARCHAR(3000)	NULL,
	[IPXMediaType]				BIGINT			NULL,
	[IPXNetworkNumber]			NVARCHAR(3000)	NULL,
	[IPXVirtualNetNumber]		NVARCHAR(1000)	NULL,
	[KeepAliveInterval]			BIGINT			NULL,
	[KeepAliveTime]				BIGINT			NULL,
	[MACAddress]				NVARCHAR(1000)	NULL,
	[MTU]						BIGINT			NULL,
	[NumForwardPackets]			BIGINT			NULL,
	[PMTUBHDetectEnabled]		BIT				NULL,
	[PMTUDiscoveryEnabled]		BIT				NULL,
	[ServiceName]				NVARCHAR(1000)	NULL,
	[TcpipNetbiosOptions]		BIGINT			NULL,
	[TcpMaxConnectRetransmissions]	BIGINT		NULL,
	[TcpMaxDataRetransmissions]	BIGINT			NULL,
	[TcpNumConnections]			BIGINT			NULL,
	[TcpUseRFC1122UrgentPointer]BIT				NULL,
	[TcpWindowSize]				INT				NULL,
	[WINSEnableLMHostsLookup]	BIT				NULL,
	[WINSHostLookupFile]		NVARCHAR(1000)	NULL,
	[WINSPrimaryServer]			NVARCHAR(1000)	NULL,
	[WINSScopeID]				NVARCHAR(1000)	NULL,
	[WINSSecondaryServer]		NVARCHAR(1000)	NULL,


	
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_NetworkAdapterConfiguration_Win32_NetworkAdapterConfigurationGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_NetworkAdapterConfigurationGuid]),
	CONSTRAINT [Asset_Win32_NetworkAdapterConfiguration_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO

create nonclustered index Asset_Win32_NetworkAdapterConfiguration_DeviceGuid_IX on Asset_Win32_NetworkAdapterConfiguration(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_NetworkAdapterConfiguration_Win32_NetworkAdapterConfigurationGuid_UX 
	on Asset_Win32_NetworkAdapterConfiguration(Win32_NetworkAdapterConfigurationGuid) 
go


CREATE TABLE  [Asset_Win32_PhysicalMemory]
(
	[Win32_PhysicalMemoryGuid] UNIQUEIDENTIFIER NOT NULL, 
    [DeviceGuid] UNIQUEIDENTIFIER NOT NULL, 
    [Attributes] BIGINT NULL, 
    [BankLabel] NVARCHAR(64) NULL, 
    [Capacity] BIGINT NULL, 
    [Caption] NVARCHAR(500) NULL, 
    [ConfiguredClockSpeed] BIGINT NULL, 
    [ConfiguredVoltage] BIGINT NULL, 
    [CreationClassName] NVARCHAR(256) NULL, 
    [DataWidth] INT NULL, 
    [Description] NVARCHAR(2000) NULL, 
    [DeviceLocator] NVARCHAR(1000) NULL, 
    [FormFactor] INT NULL, 
    [HotSwappable] BIT NULL, 
    [InstallDate] DATETIME NULL, 
    [InterleaveDataDepth] INT NULL, 
    [InterleavePosition] BIGINT NULL, 
    [Manufacturer] NVARCHAR(256) NULL, 
    [MaxVoltage] BIGINT NULL, 
    [MemoryType] INT NULL, 
    [MinVoltage] BIGINT NULL, 
    [Model] NVARCHAR(64) NULL, 
    [Name] NVARCHAR(1000) NULL, 
    [OtherIdentifyingInfo] NVARCHAR(1000) NULL, 
    [PartNumber] NVARCHAR(256) NULL, 
    [PositionInRow] BIGINT NULL, 
    [PoweredOn] BIT NULL, 
    [Removable] BIT NULL, 
    [Replaceable] BIT NULL,
	[SerialNumber] NVARCHAR(64) NULL,
    [Speed] BIGINT NULL, 
	[SKU] NVARCHAR(64) NULL, 
	[SMBIOSMemoryType] BIGINT NULL, 
	[Status] NVARCHAR(10) NULL, 
    [Tag] NVARCHAR(256) NULL,
    [TotalWidth] INT NULL,
	[TypeDetail] INT NULL, 
    [Version] NVARCHAR(64) NULL,
	[DateCreated] DATETIME NOT NULL, 
	[DateModified] DATETIME NOT NULL, 
	[OMRowVersion] TIMESTAMP NOT NULL, 		
     
    CONSTRAINT [Asset_Win32_PhysicalMemory_Win32_PhysicalMemoryGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_PhysicalMemoryGuid]),
    CONSTRAINT [Asset_Win32_PhysicalMemory_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
)
go

create nonclustered index Asset_Win32_PhysicalMemory_DeviceGuid_IX on Asset_Win32_PhysicalMemory(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_PhysicalMemory_Win32_PhysicalMemoryGuid_UX 
	on Asset_Win32_PhysicalMemory(Win32_PhysicalMemoryGuid) 
go



CREATE TABLE [Asset_Win32_Processor]
(
	[Win32_ProcessorGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid] UNIQUEIDENTIFIER NOT NULL,
	[DeviceID] NVARCHAR(1000) NULL , 
    [AddressWidth] INT NULL, 
    [Architecture] INT NULL, 
    [Availability] INT NULL, 
    [Caption] NVARCHAR(500) NULL, 
    [ConfigManagerErrorCode] BIGINT NULL, 
    [ConfigManagerUserConfig] BIT NULL, 
    [CpuStatus] INT NULL, 
    [CreationClassName] NVARCHAR(1000) NULL, 
    [CurrentClockSpeed] BIGINT NULL, 
    [CurrentVoltage] INT NULL, 
    [DataWidth] INT NULL, 
    [Description] NVARCHAR(2000) NULL, 
    [ErrorCleared] BIT NULL, 
    [ErrorDescription] NVARCHAR(2000) NULL, 
    [ExtClock] BIGINT NULL, 
    [Family] INT NULL, 
    [InstallDate] DATETIME NULL, 
    [L2CacheSize] BIGINT NULL, 
    [L2CacheSpeed] BIGINT NULL, 
    [L3CacheSize] BIGINT NULL, 
    [L3CacheSpeed] BIGINT NULL, 
    [LastErrorCode] BIGINT NULL, 
    [Level] INT NULL, 
    [LoadPercentage] INT NULL, 
    [Manufacturer] NVARCHAR(1000) NULL, 
    [MaxClockSpeed] BIGINT NULL, 
    [Name] NVARCHAR(1000) NULL, 
    [NumberOfCores] BIGINT NULL, 
    [NumberOfLogicalProcessors] BIGINT NULL, 
    [OtherFamilyDescription] NVARCHAR(1000) NULL, 
    [PNPDeviceID] NVARCHAR(1000) NULL, 
    [PowerManagementCapabilities] NVARCHAR(3000) NULL, 
    [PowerManagementSupported] BIT NULL, 
    [ProcessorId] NVARCHAR(1000) NULL, 
    [ProcessorType] INT NULL, 
    [Revision] INT NULL, 
    [Role] NVARCHAR(1000) NULL, 
    [SocketDesignation] NVARCHAR(1000) NULL, 
    [Status] NVARCHAR(10) NULL, 
    [StatusInfo] INT NULL, 
    [Stepping] NVARCHAR(1000) NULL, 
    [SystemCreationClassName] NVARCHAR(1000) NULL, 
    [SystemName] NVARCHAR(1000) NULL,   
	[UniqueId] NVARCHAR(1000) NULL,   
    [UpgradeMethod] INT NULL, 
    [Version] NVARCHAR(1000) NULL, 
    [VoltageCaps] BIGINT NULL, 
    [ProcessorDeviceID] NVARCHAR(1000) NULL, 
    [DateCreated] DATETIME NOT NULL, 
	[DateModified] DATETIME NOT NULL, 
	[OMRowVersion] TIMESTAMP NOT NULL, 		

	CONSTRAINT [Asset_Win32_Processor_Win32_ProcessorGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_ProcessorGuid]),
	CONSTRAINT [Asset_Win32_Processor_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
)
go

create nonclustered index Asset_Win32_Processor_DeviceGuid_IX on Asset_Win32_Processor(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_Processor_Win32_ProcessorGuid_UX 
	on Asset_Win32_Processor(Win32_ProcessorGuid) 
go



CREATE TABLE [Asset_Win32_SystemEnclosure] 
(
	[Win32_SystemEnclosureGuid] UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[AudibleAlarm]			BIT					NULL,
	[BreachDescription]		NVARCHAR(2000)		NULL,
	[CableManagementStrategy]	NVARCHAR(1000)	NULL,
	[Caption]				NVARCHAR(500)		NULL,
	[ChassisTypes]			NVARCHAR(3000)		NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[CurrentRequiredOrProduced]	INT				NULL,
	[Depth]					REAL				NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[HeatGeneration]		INT					NULL,
	[Height]				REAL				NULL,
	[HotSwappable]			BIT					NULL,
	[InstallDate]			DATETIME			NULL,
	[LockPresent]			BIT					NULL,
	[Manufacturer]			NVARCHAR(1000)		NULL,
	[Model]					NVARCHAR(1000)		NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[NumberOfPowerCords]	INT					NULL,
	[OtherIdentifyingInfo]	NVARCHAR(1000)		NULL,
	[PartNumber]			NVARCHAR(1000)		NULL,
	[PoweredOn]				BIT					NULL,
	[Removable]				BIT					NULL,
	[Replaceable]			BIT					NULL,
	[SecurityBreach]		INT					NULL,
	[SecurityStatus]		INT					NULL,
	[SerialNumber]			NVARCHAR(1000)		NULL,
	[ServiceDescriptions]	NVARCHAR(3000)		NULL,
	[ServicePhilosophy]		NVARCHAR(3000)		NULL,
	[SKU]					NVARCHAR(1000)		NULL,
	[SMBIOSAssetTag]		NVARCHAR(1000)		NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[Tag]					NVARCHAR(1000)		NULL,
	[TypeDescriptions]		NVARCHAR(3000)		NULL,
	[Version]				NVARCHAR(1000)		NULL,
	[VisibleAlarm]			BIT					NULL,
	[Weight]				REAL				NULL,
	[Width]					REAL				NULL,


	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_SystemEnclosure_Win32_SystemEnclosureGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_SystemEnclosureGuid]),
	CONSTRAINT [Asset_Win32_SystemEnclosure_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])

)
GO


create nonclustered index Asset_Win32_SystemEnclosure_DeviceGuid_IX on Asset_Win32_SystemEnclosure(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_SystemEnclosure_Win32_SystemEnclosureGuid_UX 
	on Asset_Win32_SystemEnclosure(Win32_SystemEnclosureGuid) 
go

CREATE TABLE [Asset_ProductKey]
(
	[ProductKeyGuid]     UNIQUEIDENTIFIER NOT NULL,
	[DeviceGuid]         UNIQUEIDENTIFIER NOT NULL,
    [Name]               NVARCHAR (100)   NOT NULL,
	[ProductKey]         NVARCHAR (100)   NOT NULL,

    [DateCreated]           DATETIME         NOT NULL,
    [DateModified]          DATETIME         NOT NULL,
    [OMRowVersion]          TIMESTAMP        NOT NULL,

	CONSTRAINT [Asset_ProductKey_ProductKeyGuid_PK] PRIMARY KEY NONCLUSTERED ([ProductKeyGuid]),
	CONSTRAINT [Asset_ProductKey_Device_FK] FOREIGN KEY  ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) 

);


GO
CREATE NONCLUSTERED INDEX [Asset_ProductKey_DeviceGuid_IX]  ON [Asset_ProductKey]([DeviceGuid] ) 
GO

CREATE UNIQUE NONCLUSTERED INDEX [Asset_ProductKey_ProductKeyGuid_UX] ON [Asset_ProductKey]([ProductKeyGuid] )
GO


CREATE TABLE [Asset_Win32_Environment] 
(
	[Win32_EnvironmentGuid] UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	
	[Caption]					NVARCHAR(500)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[InstallDate]				DATETIME		NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[SystemVariable]			BIT				NULL,
	[UserName]					NVARCHAR(1000)	NULL,
	[VariableValue]				NVARCHAR(3000)	NULL,
	
	

	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_Environment_Win32_EnvironmentGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_EnvironmentGuid]),
	CONSTRAINT [Asset_Win32_Environment_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
)
GO

CREATE NONCLUSTERED INDEX [Asset_Win32_Environment_DeviceGuid_IX]  ON [Asset_Win32_Environment]([DeviceGuid] ) 
GO

CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_Environment_Win32_EnvironmentGuid_UX] ON [Asset_Win32_Environment]([Win32_EnvironmentGuid] )
GO


CREATE TABLE [Asset_SMBios_Processor]
(
	[SMBios_ProcessorGuid]  UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 

	[AssetTag]              NVARCHAR(100)       NULL,
	[CoreCount]             TINYINT             NULL,
	[CoreEnabled]           TINYINT             NULL,
	[CpuNumber]             INT                 NULL,
	[CurrentSpeed]          INT                 NULL,
	[ExternalClock]         INT                 NULL,
	[Manufacturer]          NVARCHAR(100)       NULL,
	[MaxSpeed]              INT                 NULL,
	[ProcCharacteristics]   INT                 NULL,
	[ProcessorFamily]       TINYINT             NULL,
	[ProcessorID]           BIGINT	            NULL,
	[ProcessorType]         TINYINT             NULL,
	[ProcUpgrade]           TINYINT             NULL,
	[SerialNumber]          NVARCHAR(100)       NULL,
	[SocketDesignation]     NVARCHAR(100)       NULL,
	[Status]                TINYINT             NULL,
	[ThreadCount]           TINYINT             NULL,
	[Version]               NVARCHAR(100)       NULL,
	[Voltage]               TINYINT             NULL,



	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_SMBios_Processor_SMBios_Processor_PK] PRIMARY KEY NONCLUSTERED ([SMBios_ProcessorGuid]),
	CONSTRAINT [Asset_SMBios_Processor_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
)

GO

CREATE NONCLUSTERED INDEX [Asset_SMBios_Processor_DeviceGuid_IX]  ON [Asset_SMBios_Processor]([DeviceGuid] ) 
GO

CREATE UNIQUE NONCLUSTERED INDEX [Asset_SMBios_Processor_SMBios_ProcessorGuid_UX] ON [Asset_SMBios_Processor]([SMBios_ProcessorGuid] )
GO

CREATE TABLE [Asset_Win32_Printer] 
(
	[Win32_PrinterGuid]         UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			    UNIQUEIDENTIFIER	NOT NULL, 
	
	[Attributes]				BIGINT			NULL,
	[Availability]				INT				NULL,
	[AvailableJobSheets]		NVARCHAR(3000)	NULL,
	[AveragePagesPerMinute]		BIGINT			NULL,
	[Capabilities]				NVARCHAR(3000)	NULL,
	[CapabilityDescriptions]	NVARCHAR(3000)	NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[CharSetsSupported]			NVARCHAR(3000)	NULL,
	[Comment]					NVARCHAR(1000)	NULL,
	[ConfigManagerErrorCode]	BIGINT			NULL,
	[ConfigManagerUserConfig]	BIT				NULL,	
	[CreationClassName]			NVARCHAR(1000)	NULL,
	[CurrentCapabilities]		NVARCHAR(3000)	NULL,
	[CurrentCharSet]			NVARCHAR(1000)	NULL,
	[CurrentLanguage]			INT				NULL,
	[CurrentMimeType]			NVARCHAR(1000)	NULL,
	[CurrentNaturalLanguage]	NVARCHAR(1000)	NULL,
	[CurrentPaperType]			NVARCHAR(1000)	NULL,
	[Default]					BIT				NULL,
	[DefaultCapabilities]		NVARCHAR(3000)  NULL,
	[DefaultCopies]				BIGINT			NULL,
	[DefaultLanguage]			INT				NULL,
	[DefaultMimeType]			NVARCHAR(1000)	NULL,
	[DefaultNumberUp]			BIGINT			NULL,
	[DefaultPaperType]			NVARCHAR(1000)	NULL,
	[DefaultPriority]			BIGINT			NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[DetectedErrorState]		INT				NULL,
	[DeviceID]			    	NVARCHAR(1000)	NULL,
	[Direct]					BIT				NULL,
	[DoCompleteFirst]			BIT				NULL,
	[DriverName]				NVARCHAR(1000)	NULL,
	[EnableBIDI]				BIT				NULL,
	[EnableDevQueryPrint]		BIT				NULL,
	[ErrorCleared]				BIT				NULL,
	[ErrorDescription]			NVARCHAR(2000)	NULL,
	[ErrorInformation]			NVARCHAR(3000)	NULL,
	[ExtendedDetectedErrorState]	INT			NULL,
	[ExtendedPrinterStatus]		INT				NULL,
	[Hidden]					BIT				NULL,
	[HorizontalResolution]		BIGINT			NULL,
	[InstallDate]				DATETIME		NULL,
	[JobCountSinceLastReset]	BIGINT			NULL,
	[KeepPrintedJobs]			BIT				NULL,
	[LanguagesSupported]		NVARCHAR(3000)	NULL,
	[LastErrorCode]				BIGINT			NULL,
	[Local]						BIT				NULL,
	[Location]					NVARCHAR(1000)	NULL,
	[MarkingTechnology]			INT				NULL,
	[MaxCopies]					BIGINT			NULL,
	[MaxNumberUp]				BIGINT			NULL,
	[MaxSizeSupported]			BIGINT			NULL,
	[MimeTypesSupported]		NVARCHAR(3000)	NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[NaturalLanguagesSupported]	NVARCHAR(3000)	NULL,
	[Network]					BIT				NULL,
	[PaperSizesSupported]		NVARCHAR(3000)	NULL,
	[PaperTypesAvailable]		NVARCHAR(3000)	NULL,
	[Parameters]				NVARCHAR(1000)	NULL,
	[PNPDeviceID]				NVARCHAR(1000)	NULL,
	[PortName]					NVARCHAR(1000)	NULL,
	[PowerManagementCapabilities]	NVARCHAR(3000)	NULL,
	[PowerManagementSupported]	BIT				NULL,
	[PrinterPaperNames]			NVARCHAR(1000)	NULL,
	[PrinterState]				BIGINT			NULL,
	[PrinterStatus]				INT				NULL,
	[PrintJobDataType]			NVARCHAR(1000)	NULL,
	[PrintProcessor]			NVARCHAR(1000)	NULL,
	[Priority]					BIGINT			NULL,
	[Published]					BIT				NULL,
	[Queued]					BIT				NULL,
	[RawOnly]					BIT				NULL,
	[SeparatorFile]				NVARCHAR(1000)	NULL,
	[ServerName]				NVARCHAR(1000)	NULL,
	[Shared]					BIT				NULL,
	[ShareName]					NVARCHAR(1000)	NULL,
	[SpoolEnabled]				BIT				NULL,
	[StartTime]					DATETIME		NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[StatusInfo]				INT				NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]				NVARCHAR(1000)	NULL,
	[TimeOfLastReset]			DATETIME		NULL,
	[UntilTime]					DATETIME		NULL,
	[VerticalResolution]		BIGINT			NULL,
	[WorkOffline]				BIT				NULL,


	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_Printer_Win32_PrinterGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_PrinterGuid]),
	CONSTRAINT [Asset_Win32_Printer_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])	

)
GO

CREATE NONCLUSTERED INDEX [Asset_Win32_Printer_DeviceGuid_IX] ON [Asset_Win32_Printer]([DeviceGuid])
GO

CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_Printer_Win32_PrinterGuid_UX] ON [Asset_Win32_Printer]([Win32_PrinterGuid])
GO

CREATE TABLE [Asset_Device] (
	[DeviceGuid] UNIQUEIDENTIFIER NOT NULL
	,[TimeLastAssetScan] DATETIME NOT NULL
	,[DateCreated] DATETIME NOT NULL
	,[DateModified] DATETIME NOT NULL
	,[OMRowVersion] TIMESTAMP NOT NULL
	,CONSTRAINT [Asset_Device_DeviceGuid_PK] PRIMARY KEY NONCLUSTERED ([DeviceGuid])
	,CONSTRAINT [Asset_Device_DeviceGuid_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device]([DeviceGuid])
	)
GO

CREATE TABLE [Asset_IBUAgent] (
	[DeviceGuid] [UNIQUEIDENTIFIER]	NOT NULL,
	[UserName] NVARCHAR(50) NULL,	
	[ComputerID] NCHAR(4) NULL,	
	[AgentVersion] NVARCHAR(50) NULL,	
	[DateCreated] [DATETIME] NOT NULL,
	[DateModified][DATETIME] NOT NULL,
	[OMRowVersion] TIMESTAMP NOT NULL,
    CONSTRAINT [Asset_IBUAgent_DeviceGuid_PK] PRIMARY KEY  ([DeviceGuid])
);
GO

ALTER TABLE [Asset_IBUAgent] ADD CONSTRAINT [Asset_IBUAgent_DeviceGuid_Device_DeviceGuid_FK] FOREIGN KEY([DeviceGuid])
REFERENCES [Device] ([DeviceGuid])
GO