﻿CREATE TABLE [ASM_IVNT_PatchNow] (
  [DeviceID] int NOT NULL
, [BulletinID] nvarchar(36) NOT NULL
, [Status] smallint NOT NULL
, [ReasonCode] smallint NULL
);
GO
CREATE TABLE [DeviceRegistryInfo] (
  [DeviceGuid] uniqueidentifier NOT NULL
, [InstallationType] nvarchar(100) NULL
, [ReleaseId] int NULL
, [UpdateBuildRevision] int NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [MicrosoftDefender_DeviceTargetConfigs] (
  [DeviceID] int NOT NULL
, [CloudDeliveredProtection] bit NOT NULL
, [AutomaticSampleSubmission] bit NOT NULL
, [ControlledFolderAccess] bit NOT NULL
, [ProtectedFolders] ntext NULL
, [ExcludedFiles] ntext NULL
, [ExcludedFolders] ntext NULL
, [ExcludedProcesses] ntext NULL
, [ExcludedExtensions] ntext NULL
, [FullScanScheduleDay] int NULL
, [FullScanScheduleTime] int NULL
, [QuickScanScheduleTime] int NULL
, [QuickScanInterval] int NULL
, [DefinitionUpdateScheduleDay] int NULL
, [DefinitionUpdateScheduleTime] int NULL
, [DefinitionUpdateInterval] int NULL
);
GO
CREATE TABLE [MicrosoftDefender_DeviceUpdatedConfigs] (
  [DeviceID] int NOT NULL
, [CloudDeliveredProtection] bit NOT NULL
, [AutomaticSampleSubmission] bit NOT NULL
, [ControlledFolderAccess] bit NOT NULL
, [ProtectedFolders] ntext NULL
, [ExcludedFiles] ntext NULL
, [ExcludedFolders] ntext NULL
, [ExcludedProcesses] ntext NULL
, [ExcludedExtensions] ntext NULL
, [FullScanScheduleDay] int NULL
, [FullScanScheduleTime] int NULL
, [QuickScanScheduleTime] int NULL
, [QuickScanInterval] int NULL
, [DefinitionUpdateScheduleDay] int NULL
, [DefinitionUpdateScheduleTime] int NULL
, [DefinitionUpdateInterval] int NULL
, [LastUpdateTime] datetime NOT NULL
);
GO
ALTER TABLE [ASM_IVNT_PatchNow] ADD CONSTRAINT [PK_ASM_IVNT_PatchNow] PRIMARY KEY ([DeviceID],[BulletinID]);
GO
ALTER TABLE [DeviceRegistryInfo] ADD CONSTRAINT [DeviceRegistryInfo_DeviceGuid_PK] PRIMARY KEY ([DeviceGuid]);
GO
ALTER TABLE [MicrosoftDefender_DeviceTargetConfigs] ADD CONSTRAINT [PK_MicrosoftDefender_DeviceTargetConfigs] PRIMARY KEY ([DeviceID]);
GO
ALTER TABLE [MicrosoftDefender_DeviceUpdatedConfigs] ADD CONSTRAINT [PK_MicrosoftDefender_DeviceUpdatedConfigs] PRIMARY KEY ([DeviceID]);
GO
ALTER TABLE [ASM_IVNT_PatchNow] ADD CONSTRAINT [FK_ASM_IVNT_PatchNow_ASM_IVNT_Device] FOREIGN KEY ([DeviceID]) REFERENCES [ASM_IVNT_Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [MicrosoftDefender_DeviceTargetConfigs] ADD CONSTRAINT [FK_MicrosoftDefender_DeviceTargetConfigs_Device] FOREIGN KEY ([DeviceID]) REFERENCES [Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [MicrosoftDefender_DeviceUpdatedConfigs] ADD CONSTRAINT [FK_MicrosoftDefender_DeviceUpdatedConfigs_Device] FOREIGN KEY ([DeviceID]) REFERENCES [Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [AutomatedTaskParameter] ALTER COLUMN [Value] nvarchar(1024) NOT NULL;
GO

