﻿PRINT N' -- 1. Inserting data to Asset_Win32_BaseBoard table from ManagedElementAttributeData table...'
INSERT INTO [dbo].[Asset_Win32_BaseBoard] (
	[Win32_BaseBoardGuid]
	, [DeviceGuid]
	, [Caption]
	, [ConfigOptions]
	, [CreationClassName]
	, [Depth]
	, [Description]
	, [Height]
	, [HostingBoard]
	, [HotSwappable]
	, [InstallDate]
	, [Manufacturer]
	, [Model]
	, [Name]
	, [OtherIdentifyingInfo]
	, [PartNumber]
	, [PoweredOn]
	, [Product]
	, [Removable]
	, [Replaceable]
	, [RequirementsDescription]
	, [RequiresDaughterBoard]
	, [SerialNumber]
	, [SKU]
	, [SlotLayout]
	, [SpecialRequirements]
	, [Status]
	, [Tag]
	, [Version]
	, [Weight]
	, [Width]
	, [DateCreated]
	, [DateModified]
	)
SELECT ManagedElementGuid
	, [DeviceGuid]
	, [Caption]
	, [ConfigOptions]
	, [CreationClassName]
	, [Depth]
	, [Description]
	, [Height]
	, [HostingBoard]
	, [HotSwappable]
	, [InstallDate]
	, [Manufacturer]
	, [Model]
	, [Name]
	, [OtherIdentifyingInfo]
	, [PartNumber]
	, [PoweredOn]
	, [Product]
	, [Removable]
	, [Replaceable]
	, [RequirementsDescription]
	, [RequiresDaughterBoard]
	, [SerialNumber]
	, [SKU]
	, [SlotLayout]
	, [SpecialRequirements]
	, [Status]
	, [Tag]
	, [Version]
	, [Weight]
	, [Width]
	, [DateCreated]
	, DateModified = GETDATE()
FROM dbo.[vw_Win32_BaseBoard] b
GO

DROP VIEW [vw_Win32_BaseBoard]
GO

PRINT N' -- 2. Inserting data to Asset_Win32_Bios table from ManagedElementAttributeData table...'
INSERT INTO [dbo].[Asset_Win32_Bios]
           ([Win32_BiosGuid]
           ,[DeviceGuid]
           ,[BiosCharacteristics]
           ,[BIOSVersion]
           ,[BuildNumber]
           ,[Caption]
           ,[CodeSet]
           ,[CurrentLanguage]
           ,[Description]
           ,[EmbeddedControllerMajorVersion]
           ,[EmbeddedControllerMinorVersion]
           ,[IdentificationCode]
           ,[InstallableLanguages]
           ,[InstallDate]
           ,[LanguageEdition]
           ,[ListOfLanguages]
           ,[Manufacturer]
           ,[Name]
           ,[OtherTargetOS]
           ,[PrimaryBIOS]
           ,[ReleaseDate]
           ,[SerialNumber]
           ,[SMBIOSBIOSVersion]
           ,[SMBIOSMajorVersion]
           ,[SMBIOSMinorVersion]
           ,[SMBIOSPresent]
           ,[SoftwareElementID]
           ,[SoftwareElementState]
           ,[Status]
           ,[SystemBiosMajorVersion]
           ,[SystemBiosMinorVersion]
           ,[TargetOperatingSystem]
           ,[Version]
           ,[DateCreated]
           ,[DateModified])
SELECT [ManagedElementGuid]
	  ,[DeviceGuid]
      ,[BiosCharacteristics]
      ,[BIOSVersion]
      ,[BuildNumber]
      ,[Caption]
      ,[CodeSet]
      ,[CurrentLanguage]
      ,[Description]
	  ,[EmbeddedControllerMajorVersion] = NULL
      ,[EmbeddedControllerMinorVersion] = NULL
      ,[IdentificationCode]
      ,[InstallableLanguages]
      ,[InstallDate]
      ,[LanguageEdition]
      ,[ListOfLanguages]
      ,[Manufacturer]
      ,[Name]
      ,[OtherTargetOS]
      ,[PrimaryBIOS]
      ,[ReleaseDate]
      ,[SerialNumber]
      ,[SMBIOSBIOSVersion]
      ,[SMBIOSMajorVersion]
      ,[SMBIOSMinorVersion]
      ,[SMBIOSPresent]
      ,[SoftwareElementID]
      ,[SoftwareElementState]
      ,[Status]
	  ,[SystemBiosMajorVersion] = NULL
      ,[SystemBiosMinorVersion] = NULL
      ,[TargetOperatingSystem]
      ,[Version]
	  ,[DateCreated]
	  ,DateModified = GETDATE()
  FROM [dbo].[vw_Win32_Bios]
GO

DROP VIEW [vw_Win32_Bios]
GO


PRINT N' -- 3. Inserting data to Asset_Win32_ComputerSystem table from ManagedElementAttributeData table...'

INSERT INTO [dbo].[Asset_Win32_ComputerSystem] (
	[Win32_ComputerSystemGuid]
	, [DeviceGuid]
	, [AdminPasswordStatus]
	, [AutomaticManagedPagefile]
	, [AutomaticResetBootOption]
	, [AutomaticResetCapability]
	, [BootOptionOnLimit]
	, [BootOptionOnWatchDog]
	, [BootROMSupported]
	, [BootupState]
	, [BootStatus]
	, [Caption]
	, [ChassisBootupState]
	, [ChassisSKUNumber]
	, [CreationClassName]
	, [CurrentTimeZone]
	, [DaylightInEffect]
	, [Description]
	, [DNSHostName]
	, [Domain]
	, [DomainRole]
	, [EnableDaylightSavingsTime]
	, [FrontPanelResetStatus]
	, [HypervisorPresent]
	, [InfraredSupported]
	, [InitialLoadInfo]
	, [InstallDate]
	, [KeyboardPasswordStatus]
	, [LastLoadInfo]
	, [Manufacturer]
	, [Model]
	, [Name]
	, [NameFormat]
	, [NetworkServerModeEnabled]
	, [NumberOfLogicalProcessors]
	, [NumberOfProcessors]
	, [OEMLogoBitmap]
	, [OEMStringArray]
	, [PartOfDomain]
	, [PauseAfterReset]
	, [PCSystemType]
	, [PCSystemTypeEx]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [PowerOnPasswordStatus]
	, [PowerState]
	, [PowerSupplyState]
	, [PrimaryOwnerContact]
	, [PrimaryOwnerName]
	, [ResetCapability]
	, [ResetCount]
	, [ResetLimit]
	, [Roles]
	, [Status]
	, [SupportContactDescription]
	, [SystemFamily]
	, [SystemSKUNumber]
	, [SystemStartupDelay]
	, [SystemStartupOptions]
	, [SystemStartupSetting]
	, [SystemType]
	, [ThermalState]
	, [TotalPhysicalMemory]
	, [UserName]
	, [WakeUpType]
	, [Workgroup]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [AdminPasswordStatus]
	, [AutomaticManagedPagefile]
	, [AutomaticResetBootOption]
	, [AutomaticResetCapability]
	, [BootOptionOnLimit]
	, [BootOptionOnWatchDog]
	, [BootROMSupported]
	, [BootupState]
	, [BootStatus] = NULL
	, [Caption]
	, [ChassisBootupState]
	, [ChassisSKUNumber] = NULL
	, [CreationClassName]
	, [CurrentTimeZone]
	, [DaylightInEffect]
	, [Description]
	, [DNSHostName]
	, [Domain]
	, [DomainRole]
	, [EnableDaylightSavingsTime]
	, [FrontPanelResetStatus]
	, [HypervisorPresent] = NULL
	, [InfraredSupported]
	, [InitialLoadInfo]
	, [InstallDate]
	, [KeyboardPasswordStatus]
	, [LastLoadInfo]
	, [Manufacturer]
	, [Model]
	, [Name]
	, [NameFormat]
	, [NetworkServerModeEnabled]
	, [NumberOfLogicalProcessors]
	, [NumberOfProcessors]
	, [OEMLogoBitmap]
	, [OEMStringArray]
	, [PartOfDomain]
	, [PauseAfterReset]
	, [PCSystemType]
	, [PCSystemTypeEx] = NULL
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [PowerOnPasswordStatus]
	, [PowerState]
	, [PowerSupplyState]
	, [PrimaryOwnerContact]
	, [PrimaryOwnerName]
	, [ResetCapability]
	, [ResetCount]
	, [ResetLimit]
	, [Roles]
	, [Status]
	, [SupportContactDescription]
	, [SystemFamily] = NULL
	, [SystemSKUNumber] = NULL
	, [SystemStartupDelay]
	, [SystemStartupOptions]
	, [SystemStartupSetting]
	, [SystemType]
	, [ThermalState]
	, [TotalPhysicalMemory]
	, [UserName]
	, [WakeUpType]
	, [Workgroup]
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_ComputerSystem]
GO

DROP VIEW [vw_Win32_ComputerSystem]
GO

PRINT N' -- 4. Inserting data to Asset_Win32_DiskDrive table from ManagedElementAttributeData table...'

INSERT INTO [dbo].[Asset_Win32_DiskDrive] (
	[Win32_DiskDriveGuid]
	, [DeviceGuid]
	, [DeviceID]
	, [Availability]
	, [BytesPerSector]
	, [Capabilities]
	, [CapabilityDescriptions]
	, [Caption]
	, [CompressionMethod]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CreationClassName]
	, [DefaultBlockSize]
	, [Description]
	, [ErrorCleared]
	, [ErrorDescription]
	, [ErrorMethodology]
	, [FirmwareRevision]
	, [Index]
	, [InstallDate]
	, [InterfaceType]
	, [LastErrorCode]
	, [Manufacturer]
	, [MaxBlockSize]
	, [MaxMediaSize]
	, [MediaLoaded]
	, [MediaType]
	, [MinBlockSize]
	, [Model]
	, [Name]
	, [NeedsCleaning]
	, [NumberOfMediaSupported]
	, [Partitions]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [SCSIBus]
	, [SCSILogicalUnit]
	, [SCSIPort]
	, [SCSITargetId]
	, [SectorsPerTrack]
	, [SerialNumber]
	, [Signature]
	, [Size]
	, [Status]
	, [StatusInfo]
	, [SystemCreationClassName]
	, [SystemName]
	, [TotalCylinders]
	, [TotalHeads]
	, [TotalSectors]
	, [TotalTracks]
	, [TracksPerCylinder]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [DeviceID]
	, [Availability]
	, [BytesPerSector]
	, [Capabilities]
	, [CapabilityDescriptions]
	, [Caption]
	, [CompressionMethod]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CreationClassName]
	, [DefaultBlockSize]
	, [Description]
	, [ErrorCleared]
	, [ErrorDescription]
	, [ErrorMethodology]
	, [FirmwareRevision]
	, [Index]
	, [InstallDate]
	, [InterfaceType]
	, [LastErrorCode]
	, [Manufacturer]
	, [MaxBlockSize]
	, [MaxMediaSize]
	, [MediaLoaded]
	, [MediaType]
	, [MinBlockSize]
	, [Model]
	, [Name]
	, [NeedsCleaning]
	, [NumberOfMediaSupported]
	, [Partitions]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [SCSIBus]
	, [SCSILogicalUnit]
	, [SCSIPort]
	, [SCSITargetId]
	, [SectorsPerTrack]
	, [SerialNumber]
	, [Signature]
	, [Size]
	, [Status]
	, [StatusInfo]
	, [SystemCreationClassName]
	, [SystemName]
	, [TotalCylinders]
	, [TotalHeads]
	, [TotalSectors]
	, [TotalTracks]
	, [TracksPerCylinder]
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_DiskDrive]
GO

DROP VIEW [vw_Win32_DiskDrive]
GO

PRINT N' -- 5. Inserting data to Asset_Win32_LogicalDisk table from ManagedElementAttributeData table...'

INSERT INTO [dbo].[Asset_Win32_LogicalDisk] (
	[Win32_LogicalDiskGuid]
	, [DeviceGuid]
	, [DeviceID]
	, [Access]
	, [Availability]
	, [BlockSize]
	, [Caption]
	, [Compressed]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CreationClassName]
	, [Description]
	, [DriveType]
	, [ErrorCleared]
	, [ErrorDescription]
	, [ErrorMethodology]
	, [FileSystem]
	, [FreeSpace]
	, [InstallDate]
	, [LastErrorCode]
	, [MaximumComponentLength]
	, [MediaType]
	, [Name]
	, [NumberOfBlocks]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [ProviderName]
	, [Purpose]
	, [QuotasDisabled]
	, [QuotasIncomplete]
	, [QuotasRebuilding]
	, [Size]
	, [Status]
	, [StatusInfo]
	, [SupportsDiskQuotas]
	, [SupportsFileBasedCompression]
	, [SystemCreationClassName]
	, [SystemName]
	, [VolumeDirty]
	, [VolumeName]
	, [VolumeSerialNumber]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [DeviceID]
	, [Access]
	, [Availability]
	, [BlockSize]
	, [Caption]
	, [Compressed]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CreationClassName]
	, [Description]
	, [DriveType]
	, [ErrorCleared]
	, [ErrorDescription]
	, [ErrorMethodology]
	, [FileSystem]
	, [FreeSpace]
	, [InstallDate]
	, [LastErrorCode]
	, [MaximumComponentLength]
	, [MediaType]
	, [Name]
	, [NumberOfBlocks]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [ProviderName]
	, [Purpose]
	, [QuotasDisabled]
	, [QuotasIncomplete]
	, [QuotasRebuilding]
	, [Size]
	, [Status]
	, [StatusInfo]
	, [SupportsDiskQuotas]
	, [SupportsFileBasedCompression]
	, [SystemCreationClassName]
	, [SystemName]
	, [VolumeDirty]
	, [VolumeName]
	, [VolumeSerialNumber]
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_LogicalDisk]
GO

DROP VIEW [vw_Win32_LogicalDisk]
GO

PRINT N' -- 6. Inserting data to Asset_Win32_MotherBoardDevice table from ManagedElementAttributeData table...'

INSERT INTO [dbo].[Asset_Win32_MotherBoardDevice] (
	[Win32_MotherBoardDeviceGuid]
	, [DeviceGuid]
	, [Availability]
	, [Caption]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CreationClassName]
	, [Description]
	, [DeviceID]
	, [ErrorCleared]
	, [ErrorDescription]
	, [InstallDate]
	, [LastErrorCode]
	, [Name]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [PrimaryBusType]
	, [RevisionNumber]
	, [SecondaryBusType]
	, [Status]
	, [StatusInfo]
	, [SystemCreationClassName]
	, [SystemName]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [Availability]
	, [Caption]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CreationClassName]
	, [Description]
	, [DeviceID]
	, [ErrorCleared]
	, [ErrorDescription]
	, [InstallDate]
	, [LastErrorCode]
	, [Name]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [PrimaryBusType]
	, [RevisionNumber]
	, [SecondaryBusType]
	, [Status]
	, [StatusInfo]
	, [SystemCreationClassName]
	, [SystemName]
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_MotherBoardDevice]
GO

DROP VIEW [vw_Win32_MotherBoardDevice]
GO

PRINT N' -- 7. Inserting data to Asset_Win32_NetworkAdapter table from ManagedElementAttributeData table...'
INSERT INTO [dbo].[Asset_Win32_NetworkAdapter] (
	[Win32_NetworkAdapterGuid]
	, [DeviceGuid]
	, [AdapterType]
	, [AdapterTypeId]
	, [AutoSense]
	, [Availability]
	, [Caption]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CreationClassName]
	, [Description]
	, [DeviceID]
	, [ErrorCleared]
	, [ErrorDescription]
	, [GUID]
	, [Index]
	, [InstallDate]
	, [Installed]
	, [InterfaceIndex]
	, [LastErrorCode]
	, [MACAddress]
	, [Manufacturer]
	, [MaxNumberControlled]
	, [MaxSpeed]
	, [Name]
	, [NetConnectionID]
	, [NetConnectionStatus]
	, [NetEnabled]
	, [NetworkAddresses]
	, [PermanentAddress]
	, [PhysicalAdapter]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [ProductName]
	, [ServiceName]
	, [Speed]
	, [Status]
	, [StatusInfo]
	, [SystemCreationClassName]
	, [SystemName]
	, [TimeOfLastReset]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [AdapterType]
	, [AdapterTypeId]
	, [AutoSense]
	, [Availability]
	, [Caption]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CreationClassName]
	, [Description]
	, [DeviceID]
	, [ErrorCleared]
	, [ErrorDescription]
	, [GUID]
	, [Index]
	, [InstallDate]
	, [Installed]
	, [InterfaceIndex]
	, [LastErrorCode]
	, [MACAddress]
	, [Manufacturer]
	, [MaxNumberControlled]
	, [MaxSpeed]
	, [Name]
	, [NetConnectionID]
	, [NetConnectionStatus]
	, [NetEnabled]
	, [NetworkAddresses]
	, [PermanentAddress]
	, [PhysicalAdapter]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [ProductName]
	, [ServiceName]
	, [Speed]
	, [Status]
	, [StatusInfo]
	, [SystemCreationClassName]
	, [SystemName]
	, [TimeOfLastReset]
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_NetworkAdapter]
GO

DROP VIEW [vw_Win32_NetworkAdapter]
GO

PRINT N' -- 8. Inserting data to Asset_Win32_NetworkAdapterConfiguration table from ManagedElementAttributeData table...'
INSERT INTO [dbo].[Asset_Win32_NetworkAdapterConfiguration] (
	[Win32_NetworkAdapterConfigurationGuid]
	, [DeviceGuid]
	, [ArpAlwaysSourceRoute]
	, [ArpUseEtherSNAP]
	, [Caption]
	, [DatabasePath]
	, [DeadGWDetectEnabled]
	, [DefaultIPGateway]
	, [DefaultTOS]
	, [DefaultTTL]
	, [Description]
	, [DHCPEnabled]
	, [DHCPLeaseExpires]
	, [DHCPLeaseObtained]
	, [DHCPServer]
	, [DNSDomain]
	, [DNSDomainSuffixSearchOrder]
	, [DNSEnabledForWINSResolution]
	, [DNSHostName]
	, [DNSServerSearchOrder]
	, [DomainDNSRegistrationEnabled]
	, [ForwardBufferMemory]
	, [FullDNSRegistrationEnabled]
	, [GatewayCostMetric]
	, [IGMPLevel]
	, [Index]
	, [InterfaceIndex]
	, [IPAddress]
	, [IPConnectionMetric]
	, [IPEnabled]
	, [IPFilterSecurityEnabled]
	, [IPPortSecurityEnabled]
	, [IPSecPermitIPProtocols]
	, [IPSecPermitTCPPorts]
	, [IPSecPermitUDPPorts]
	, [IPSubnet]
	, [IPUseZeroBroadcast]
	, [IPXAddress]
	, [IPXEnabled]
	, [IPXFrameType]
	, [IPXMediaType]
	, [IPXNetworkNumber]
	, [IPXVirtualNetNumber]
	, [KeepAliveInterval]
	, [KeepAliveTime]
	, [MACAddress]
	, [MTU]
	, [NumForwardPackets]
	, [PMTUBHDetectEnabled]
	, [PMTUDiscoveryEnabled]
	, [ServiceName]
	, [SettingID]
	, [TcpipNetbiosOptions]
	, [TcpMaxConnectRetransmissions]
	, [TcpMaxDataRetransmissions]
	, [TcpNumConnections]
	, [TcpUseRFC1122UrgentPointer]
	, [TcpWindowSize]
	, [WINSEnableLMHostsLookup]
	, [WINSHostLookupFile]
	, [WINSPrimaryServer]
	, [WINSScopeID]
	, [WINSSecondaryServer]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [ArpAlwaysSourceRoute]
	, [ArpUseEtherSNAP]
	, [Caption]
	, [DatabasePath]
	, [DeadGWDetectEnabled]
	, [DefaultIPGateway]
	, [DefaultTOS]
	, [DefaultTTL]
	, [Description]
	, [DHCPEnabled]
	, [DHCPLeaseExpires]
	, [DHCPLeaseObtained]
	, [DHCPServer]
	, [DNSDomain]
	, [DNSDomainSuffixSearchOrder]
	, [DNSEnabledForWINSResolution]
	, [DNSHostName]
	, [DNSServerSearchOrder]
	, [DomainDNSRegistrationEnabled]
	, [ForwardBufferMemory]
	, [FullDNSRegistrationEnabled]
	, [GatewayCostMetric]
	, [IGMPLevel]
	, [Index]
	, [InterfaceIndex]
	, [IPAddress]
	, [IPConnectionMetric]
	, [IPEnabled]
	, [IPFilterSecurityEnabled]
	, [IPPortSecurityEnabled]
	, [IPSecPermitIPProtocols]
	, [IPSecPermitTCPPorts]
	, [IPSecPermitUDPPorts]
	, [IPSubnet]
	, [IPUseZeroBroadcast]
	, [IPXAddress]
	, [IPXEnabled]
	, [IPXFrameType]
	, [IPXMediaType]
	, [IPXNetworkNumber]
	, [IPXVirtualNetNumber]
	, [KeepAliveInterval]
	, [KeepAliveTime]
	, [MACAddress]
	, [MTU]
	, [NumForwardPackets]
	, [PMTUBHDetectEnabled]
	, [PMTUDiscoveryEnabled]
	, [ServiceName]
	, [SettingID]
	, [TcpipNetbiosOptions]
	, [TcpMaxConnectRetransmissions]
	, [TcpMaxDataRetransmissions]
	, [TcpNumConnections]
	, [TcpUseRFC1122UrgentPointer]
	, [TcpWindowSize]
	, [WINSEnableLMHostsLookup]
	, [WINSHostLookupFile]
	, [WINSPrimaryServer]
	, [WINSScopeID]
	, [WINSSecondaryServer]
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_NetworkAdapterConfiguration]
GO

DROP VIEW [vw_Win32_NetworkAdapterConfiguration]
GO

PRINT N' -- 9. Inserting data to Asset_Win32_OperatingSystem table from ManagedElementAttributeData table...'
INSERT INTO [dbo].[Asset_Win32_OperatingSystem] (
	[Win32_OperatingSystemGuid]
	, [DeviceGuid]
	, [BootDevice]
	, [BuildNumber]
	, [BuildType]
	, [Caption]
	, [CodeSet]
	, [CountryCode]
	, [CreationClassName]
	, [CSCreationClassName]
	, [CSDVersion]
	, [CSName]
	, [CurrentTimeZone]
	, [DataExecutionPrevention_Available]
	, [DataExecutionPrevention_32BitApplications]
	, [DataExecutionPrevention_Drivers]
	, [DataExecutionPrevention_SupportPolicy]
	, [Debug]
	, [Description]
	, [Distributed]
	, [EncryptionLevel]
	, [ForegroundApplicationBoost]
	, [FreePhysicalMemory]
	, [FreeSpaceInPagingFiles]
	, [FreeVirtualMemory]
	, [InstallDate]
	, [LargeSystemCache]
	, [LastBootUpTime]
	, [LocalDateTime]
	, [Locale]
	, [Manufacturer]
	, [MaxNumberOfProcesses]
	, [MaxProcessMemorySize]
	, [MUILanguages]
	, [Name]
	, [NumberOfLicensedUsers]
	, [NumberOfProcesses]
	, [NumberOfUsers]
	, [OperatingSystemSKU]
	, [Organization]
	, [OSArchitecture]
	, [OSLanguage]
	, [OSProductSuite]
	, [OSType]
	, [OtherTypeDescription]
	, [PAEEnabled]
	, [PlusProductID]
	, [PlusVersionNumber]
	, [PortableOperatingSystem]
	, [Primary]
	, [ProductType]
	, [RegisteredUser]
	, [SerialNumber]
	, [ServicePackMajorVersion]
	, [ServicePackMinorVersion]
	, [SizeStoredInPagingFiles]
	, [Status]
	, [SuiteMask]
	, [SystemDevice]
	, [SystemDirectory]
	, [SystemDrive]
	, [TotalSwapSpaceSize]
	, [TotalVirtualMemorySize]
	, [TotalVisibleMemorySize]
	, [Version]
	, [WindowsDirectory]
	, [QuantumLength]
	, [QuantumType]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [BootDevice]
	, [BuildNumber]
	, [BuildType]
	, [Caption]
	, [CodeSet]
	, [CountryCode]
	, [CreationClassName]
	, [CSCreationClassName]
	, [CSDVersion]
	, [CSName]
	, [CurrentTimeZone]
	, [DataExecutionPrevention_Available]
	, [DataExecutionPrevention_32BitApplications]
	, [DataExecutionPrevention_Drivers]
	, [DataExecutionPrevention_SupportPolicy]
	, [Debug]
	, [Description]
	, [Distributed]
	, [EncryptionLevel]
	, [ForegroundApplicationBoost]
	, [FreePhysicalMemory]
	, [FreeSpaceInPagingFiles]
	, [FreeVirtualMemory]
	, [InstallDate]
	, [LargeSystemCache]
	, [LastBootUpTime]
	, [LocalDateTime]
	, [Locale]
	, [Manufacturer]
	, [MaxNumberOfProcesses]
	, [MaxProcessMemorySize]
	, [MUILanguages]
	, [Name]
	, [NumberOfLicensedUsers]
	, [NumberOfProcesses]
	, [NumberOfUsers]
	, [OperatingSystemSKU]
	, [Organization]
	, [OSArchitecture]
	, [OSLanguage]
	, [OSProductSuite]
	, [OSType]
	, [OtherTypeDescription]
	, [PAEEnabled]
	, [PlusProductID]
	, [PlusVersionNumber]
	, [PortableOperatingSystem] = NULL
	, [Primary]
	, [ProductType]
	, [RegisteredUser]
	, [SerialNumber]
	, [ServicePackMajorVersion]
	, [ServicePackMinorVersion]
	, [SizeStoredInPagingFiles]
	, [Status]
	, [SuiteMask]
	, [SystemDevice]
	, [SystemDirectory]
	, [SystemDrive]
	, [TotalSwapSpaceSize]
	, [TotalVirtualMemorySize]
	, [TotalVisibleMemorySize]
	, [Version]
	, [WindowsDirectory]
	, [QuantumLength] = NULL
	, [QuantumType] = NULL
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_OperatingSystem]
GO

DROP VIEW [vw_Win32_OperatingSystem]
GO

PRINT N' -- 10. Inserting data to Asset_Win32_PhysicalMemory table from ManagedElementAttributeData table...'
INSERT INTO [dbo].[Asset_Win32_PhysicalMemory] (
	[Win32_PhysicalMemoryGuid]
	, [DeviceGuid]
	, [Attributes]
	, [BankLabel]
	, [Capacity]
	, [Caption]
	, [ConfiguredClockSpeed]
	, [ConfiguredVoltage]
	, [CreationClassName]
	, [DataWidth]
	, [Description]
	, [DeviceLocator]
	, [FormFactor]
	, [HotSwappable]
	, [InstallDate]
	, [InterleaveDataDepth]
	, [InterleavePosition]
	, [Manufacturer]
	, [MaxVoltage]
	, [MemoryType]
	, [MinVoltage]
	, [Model]
	, [Name]
	, [OtherIdentifyingInfo]
	, [PartNumber]
	, [PositionInRow]
	, [PoweredOn]
	, [Removable]
	, [Replaceable]
	, [SerialNumber]
	, [Speed]
	, [SKU]
	, [SMBIOSMemoryType]
	, [Status]
	, [Tag]
	, [TotalWidth]
	, [TypeDetail]
	, [Version]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [Attributes] = NULL
	, [BankLabel]
	, [Capacity]
	, [Caption]
	, [ConfiguredClockSpeed] = NULL
	, [ConfiguredVoltage] = NULL
	, [CreationClassName] = NULL
	, [DataWidth]
	, [Description]
	, [DeviceLocator]
	, [FormFactor]
	, [HotSwappable]
	, [InstallDate]
	, [InterleaveDataDepth]
	, [InterleavePosition]
	, [Manufacturer]
	, [MaxVoltage] = NULL
	, [MemoryType]
	, [MinVoltage] = NULL
	, [Model]
	, [Name]
	, [OtherIdentifyingInfo]
	, [PartNumber]
	, [PositionInRow]
	, [PoweredOn]
	, [Removable]
	, [Replaceable]
	, [SerialNumber]
	, [Speed]
	, [SKU]
	, [SMBIOSMemoryType] = NULL
	, [Status]
	, [Tag]
	, [TotalWidth]
	, [TypeDetail]
	, [Version]
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_PhysicalMemory]
GO

DROP VIEW [vw_Win32_PhysicalMemory]
GO

PRINT N' -- 11. Inserting data to Asset_Win32_Processor table from ManagedElementAttributeData table...'
INSERT INTO [dbo].[Asset_Win32_Processor] (
	[Win32_ProcessorGuid]
	, [DeviceGuid]
	, [AddressWidth]
	, [Architecture]
	, [Availability]
	, [Caption]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CpuStatus]
	, [CreationClassName]
	, [CurrentClockSpeed]
	, [CurrentVoltage]
	, [DataWidth]
	, [Description]
	, [DeviceID]
	, [ErrorCleared]
	, [ErrorDescription]
	, [ExtClock]
	, [Family]
	, [InstallDate]
	, [L2CacheSize]
	, [L2CacheSpeed]
	, [L3CacheSize]
	, [L3CacheSpeed]
	, [LastErrorCode]
	, [Level]
	, [LoadPercentage]
	, [Manufacturer]
	, [MaxClockSpeed]
	, [Name]
	, [NumberOfCores]
	, [NumberOfLogicalProcessors]
	, [OtherFamilyDescription]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [ProcessorId]
	, [ProcessorType]
	, [Revision]
	, [Role]
	, [SocketDesignation]
	, [Status]
	, [StatusInfo]
	, [Stepping]
	, [SystemCreationClassName]
	, [SystemName]
	, [UniqueId]
	, [UpgradeMethod]
	, [Version]
	, [VoltageCaps]
	, [ProcessorDeviceID]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [AddressWidth]
	, [Architecture]
	, [Availability]
	, [Caption]
	, [ConfigManagerErrorCode]
	, [ConfigManagerUserConfig]
	, [CpuStatus]
	, [CreationClassName]
	, [CurrentClockSpeed]
	, [CurrentVoltage]
	, [DataWidth]
	, [Description]
	, [DeviceID]
	, [ErrorCleared]
	, [ErrorDescription]
	, [ExtClock]
	, [Family]
	, [InstallDate]
	, [L2CacheSize]
	, [L2CacheSpeed]
	, [L3CacheSize]
	, [L3CacheSpeed]
	, [LastErrorCode]
	, [Level]
	, [LoadPercentage]
	, [Manufacturer]
	, [MaxClockSpeed]
	, [Name]
	, [NumberOfCores]
	, [NumberOfLogicalProcessors]
	, [OtherFamilyDescription]
	, [PNPDeviceID]
	, [PowerManagementCapabilities]
	, [PowerManagementSupported]
	, [ProcessorId]
	, [ProcessorType]
	, [Revision]
	, [Role]
	, [SocketDesignation]
	, [Status]
	, [StatusInfo]
	, [Stepping]
	, [SystemCreationClassName]
	, [SystemName]
	, [UniqueId]
	, [UpgradeMethod]
	, [Version]
	, [VoltageCaps]
	, [ProcessorDeviceID] = NULL
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_Processor]
GO

DROP VIEW [vw_Win32_Processor]
GO

PRINT N' -- 12. Inserting data to Asset_Win32_SystemEnclosure table from ManagedElementAttributeData table...'
INSERT INTO [dbo].[Asset_Win32_SystemEnclosure] (
	[Win32_SystemEnclosureGuid]
	, [DeviceGuid]
	, [AudibleAlarm]
	, [BreachDescription]
	, [CableManagementStrategy]
	, [Caption]
	, [ChassisTypes]
	, [CreationClassName]
	, [CurrentRequiredOrProduced]
	, [Depth]
	, [Description]
	, [HeatGeneration]
	, [Height]
	, [HotSwappable]
	, [InstallDate]
	, [LockPresent]
	, [Manufacturer]
	, [Model]
	, [Name]
	, [NumberOfPowerCords]
	, [OtherIdentifyingInfo]
	, [PartNumber]
	, [PoweredOn]
	, [Removable]
	, [Replaceable]
	, [SecurityBreach]
	, [SecurityStatus]
	, [SerialNumber]
	, [ServiceDescriptions]
	, [ServicePhilosophy]
	, [SKU]
	, [SMBIOSAssetTag]
	, [Status]
	, [Tag]
	, [TypeDescriptions]
	, [Version]
	, [VisibleAlarm]
	, [Weight]
	, [Width]
	, [DateCreated]
	, [DateModified]
	)
SELECT [ManagedElementGuid]
	, [DeviceGuid]
	, [AudibleAlarm]
	, [BreachDescription]
	, [CableManagementStrategy]
	, [Caption]
	, [ChassisTypes]
	, [CreationClassName]
	, [CurrentRequiredOrProduced]
	, [Depth]
	, [Description]
	, [HeatGeneration]
	, [Height]
	, [HotSwappable]
	, [InstallDate]
	, [LockPresent]
	, [Manufacturer]
	, [Model]
	, [Name]
	, [NumberOfPowerCords]
	, [OtherIdentifyingInfo]
	, [PartNumber]
	, [PoweredOn]
	, [Removable]
	, [Replaceable]
	, [SecurityBreach]
	, [SecurityStatus]
	, [SerialNumber]
	, [ServiceDescriptions]
	, [ServicePhilosophy]
	, [SKU]
	, [SMBIOSAssetTag]
	, [Status]
	, [Tag]
	, [TypeDescriptions]
	, [Version]
	, [VisibleAlarm]
	, [Weight]
	, [Width]
	, [DateCreated]
	, DateModified = GETDATE()
FROM [dbo].[vw_Win32_SystemEnclosure]
GO

DROP VIEW [vw_Win32_SystemEnclosure]
GO

