﻿/*
	ME2Category
*/
ALTER TABLE [ME2Category] ADD 
    CONSTRAINT [ME2Category_PK] PRIMARY KEY   
	([ME2CategoryID])
go

alter table OSX_Application
   add constraint OSX_Application_PK PRIMARY KEY   
													 
	(DeviceGuid,SyncGuid)
go

 alter table OSX_DiscBurning
    add constraint OSX_DiscBurning_PK PRIMARY KEY   
													 
	(DeviceGuid,SyncGuid)
go

 alter table OSX_DiskVolume
    add constraint OSX_DiskVolume_PK PRIMARY KEY   
												  
	(DeviceGuid,SyncGuid)
go

 alter table OSX_Display
    add constraint OSX_Display_PK PRIMARY KEY   
											     
	(DeviceGuid,SyncGuid)
go

alter table OSX_DisplayAdapter
    add constraint OSX_DisplayAdapter_PK PRIMARY KEY   
												 
    (DeviceGuid,SyncGuid)
go

alter table OSX_HardwareOverview
    add constraint OSX_HardwareOverview_PK PRIMARY KEY   
												 
	(DeviceGuid)
go

alter table OSX_MemoryBank
    add constraint OSX_MemoryBank_PK PRIMARY KEY   
													 
	(DeviceGuid,SyncGuid)
go

alter table OSX_NetworkInterface
    add constraint OSX_NetworkInterface_PK PRIMARY KEY   
														 
	(DeviceGuid,SyncGuid)
go

alter table OSX_OperatingSystem
    add constraint OSX_OperatingSystem_PK PRIMARY KEY   
														 
	(DeviceGuid)
go

alter table OSX_PhysicalDisk
    add constraint OSX_PhysicalDisk_PK PRIMARY KEY   
	                                                 
	(DeviceGuid,SyncGuid)
go

alter table VmInfo
    add constraint VmInfo_PK PRIMARY KEY   
				                             
		(DeviceGuid, MachineGuid)
go

ALTER TABLE [DeviceCoreInfo] ADD 
    CONSTRAINT [DeviceCoreInfo_PK] PRIMARY KEY   
												 
	([DeviceGuid])
go






/* 
	[KeyHierarchy]    
*/
CREATE TABLE [KeyHierarchy]
(
	[InstallationID]		uniqueidentifier    NOT NULL,
	[MasterKey]				[image]				NOT NULL,
	[MasterIV]				[image]				NOT NULL,
	[SymmetricKey]			[image]				NOT NULL,
	[SymmetricIV]			[image]				NOT NULL,
	[AsymmetricPublicKey]	[image]				NOT NULL,
	[AsymmetricPrivateKey]	[image]				NOT NULL
) 
GO

alter TABLE [KeyHierarchy]
 add CONSTRAINT [PK_KeyHierarchy] PRIMARY KEY    
(
	[InstallationID] 	
)
go

/*
	[SecurableType]    
*/
alter TABLE [SecurableType]
	add CONSTRAINT [SecurableType_PK] PRIMARY KEY    
	(
		[SecurableTypeID] 
	)
GO

/*
	[OwnerType]  
*/
alter TABLE [OwnerType]
	add CONSTRAINT [OwnerType_PK] PRIMARY KEY    
	(
		[OwnerTypeID] 
	)
GO

/*
	 [ManufacturerOidMap]    
*/
alter table [ManufacturerOidMap]
	add CONSTRAINT [ManufacturerOidMap_PK] PRIMARY KEY    
	(
		[ManufacturerID] 
	)
go


/* 
	[DiscoveryScanResult]    
*/
alter table [DiscoveryScanResult]
	add CONSTRAINT [PK_DiscoveryScanResult] PRIMARY KEY    
(
	[RunID] 
)

GO

/* 
	[DiscoveryDeviceADComputerEntry]    
*/
alter table [DiscoveryDeviceADComputerEntry]
	add CONSTRAINT [PK_DiscoveryDeviceADComputerEntry] PRIMARY KEY    
(
	[DeviceGuid] 
)
go

/* 
	[DiscoveryDevice]    
*/
alter table [DiscoveryDevice]
	add CONSTRAINT [PK_DiscoveryDevice] PRIMARY KEY    
(
	[DeviceGuid]
)
GO

/* 
	[AuthenticationType]  
*/
alter table [AuthenticationType]
	add CONSTRAINT [AuthenticationType_PK] PRIMARY KEY    
(
	[AuthenticationTypeID] 
)
GO

/* 
	[CredentialSet]    
*/
alter table [CredentialSet]
	add CONSTRAINT [CredentialSet_PK] PRIMARY KEY    
(
	[CredentialSetGuid] 
)
GO

/* 
	[CredentialSetObjectLink]   
*/
alter table [CredentialSetObjectLink]
	add CONSTRAINT [CredentialObjectLink_PK] PRIMARY KEY    
(
	[CredentialSetGuid] ,
	[ObjectGuid] 
)
GO

/* 
	[DiscoveryIpAddress]    
*/
alter table [DiscoveryIpAddress]
	add CONSTRAINT [PK_DiscoveryIpAddress] PRIMARY KEY    
(	
	[Address] 
)
GO


/* 
	[DiscoveryIpAddressZeroConfResponse]    
*/
alter table [DiscoveryIpAddressZeroConfResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressZeroConfResponse] PRIMARY KEY    
(
	[Address] ,
	[ServiceName] ,
	[HostName] 
)
GO


/* 
	[DiscoveryIpAddressWmiResponse]    
*/
alter table [DiscoveryIpAddressWmiResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressWmiResponse] PRIMARY KEY    
(
	[Address] 
)
GO

/* 
	[DiscoveryIpAddressSnmpResponse]    
*/
alter table [DiscoveryIpAddressSnmpResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressSnmpResponse] PRIMARY KEY    
(
	[Address] 
)
GO


/* 
	[DiscoveryIpAddressSmbResponse]    
*/
alter table [DiscoveryIpAddressSmbResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressSmbResponse] PRIMARY KEY    
(
	[Address] 
)
GO

/* 
	[DiscoveryIpAddressProtocolTiming]    
*/
alter table [DiscoveryIpAddressProtocolTiming]
	add CONSTRAINT [PK_DiscoveryIpAddressProtocolTiming] PRIMARY KEY    
(
	[RunID],
	[Address] ,
	[ProtocolName] 
)
GO

/* 
	[DiscoveryIpAddressPortInfo]    
*/
alter table [DiscoveryIpAddressPortInfo]
	add CONSTRAINT [PK_DiscoveryIpAddressPortInfo] PRIMARY KEY    
(
	[Address] ,
	[PortNumber] 
)
GO

/* 
	[DiscoveryIpAddressDnsValidatedName]    
*/
alter table [DiscoveryIpAddressDnsValidatedName]
	add CONSTRAINT [PK_DiscoveryIpAddressDnsValidatedName] PRIMARY KEY    
(
	[Address] ,
	[Name] 
)
GO

/* 
	[DiscoveryIpAddressDnsReverseLookupName]   
*/
alter table [DiscoveryIpAddressDnsReverseLookupName]
	add CONSTRAINT [PK_DiscoveryIpAddressDnsReverseLookupName] PRIMARY KEY    
(
	[Address] ,
	[Name] 
)
GO

/* 
	[DiscoveryIpAddressAfpResponse]    
*/
alter table [DiscoveryIpAddressAfpResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressAfpResponse] PRIMARY KEY    
(
	[Address] 
)
GO

/* 
	[DiscoveryIpAddressADComputerEntry]  
*/
alter table [DiscoveryIpAddressADComputerEntry]
	add CONSTRAINT [PK_DiscoveryIpAddressADComputerEntry] PRIMARY KEY    
(
	[Address] 
)
GO

/* 
	[DiscoveryIpAddressZeroConfProperty]   
*/
alter table [DiscoveryIpAddressZeroConfProperty]
	add CONSTRAINT [PK_DiscoveryIpAddressZeroConfProperty] PRIMARY KEY    
(
	[Address] ,
	[ServiceName] ,
	[PropertyName] ,
	[HostName] 
)
GO

/* 
	[DiscoveryIpAddressZeroConfIp]    
*/
alter table [DiscoveryIpAddressZeroConfIp]
	add CONSTRAINT [PK_DiscoveryIpAddressZeroConfIp] PRIMARY KEY    
(
	[Address] ,
	[ServiceName] ,
	[Ip] ,
	[HostName] 
)
GO

/* 
	[DiscoveryDeviceWmiData]    
*/
alter table [DiscoveryDeviceWmiData]
	add CONSTRAINT [PK_DiscoveryDeviceWmiData] PRIMARY KEY    
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceSmbData]    
*/
alter table [DiscoveryDeviceSmbData]
	add CONSTRAINT [PK_DiscoveryDeviceSmbData] PRIMARY KEY    
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceNetbiosData]    
*/
alter table [DiscoveryDeviceNetbiosData]
	add CONSTRAINT [PK_DiscoveryDeviceNetbiosData] PRIMARY KEY    
(
	[DeviceGuid] 
)
GO


/* 
	[DiscoveryDeviceDnsData]    
*/
alter table [DiscoveryDeviceDnsData]
	add CONSTRAINT [PK_DiscoveryDeviceDnsData] PRIMARY KEY    
(
	[DeviceGuid] ,
	[DnsName] 
)
GO

/* 
	[DiscoveryDeviceAfpResponse]   
*/
alter table [DiscoveryDeviceAfpResponse]
	add CONSTRAINT [PK_DiscoveryDeviceAfpResponse] PRIMARY KEY    
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceZeroConfResponse]    
*/
alter table [DiscoveryDeviceZeroConfResponse]
	add CONSTRAINT [PK_DiscoveryDeviceZeroConfResponse] PRIMARY KEY    
(
	[DeviceGuid] ,
	[ServiceName] 
)
GO

/* 
	[DiscoveryDeviceSnmpData]    
*/
alter table [DiscoveryDeviceSnmpData]
	add CONSTRAINT [PK_DiscoveryDeviceSnmpData] PRIMARY KEY    
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceZeroConfProperty]   
*/
alter table [DiscoveryDeviceZeroConfProperty]
	add CONSTRAINT [PK_DiscoveryDeviceZeroConfProperty] PRIMARY KEY    
(
	[DeviceGuid] ,
	[ServiceName] ,
	[PropertyName]
)
GO



/* 
	[DiscoveryDeviceWmiNetworkAdapter]    
*/
alter table [DiscoveryDeviceWmiNetworkAdapter]
	add CONSTRAINT [PK_DiscoveryDeviceWmiNetworkAdapter] PRIMARY KEY    
(
	[DeviceGuid] ,
	[MacAddress] 
)
GO

/* 
	[DiscoveryDeviceSnmpOid]    
*/
alter table [DiscoveryDeviceSnmpOid]
	add CONSTRAINT [PK_DiscoveryDeviceSnmpOid] PRIMARY KEY    
(
	[DeviceGuid] ,
	[Oid] 
)
GO

/* 
	[DiscoveryDeviceSnmpNetworkAdapter]    
*/
alter table [DiscoveryDeviceSnmpNetworkAdapter]
	add CONSTRAINT [PK_DiscoveryDeviceSnmpNetworkAdapter] PRIMARY KEY    
(
	[DeviceGuid] ,
	[MacAddress] 
)
GO

/* 
	[DiscoveryDevicePortInfo]    
*/
alter table [DiscoveryDevicePortInfo]
	add CONSTRAINT [PK_DiscoveryDevicePortInfo] PRIMARY KEY    
(
	[DeviceGuid] ,
	[PortNumber] 
)
GO

/* 
	[CredentialAttribute]   
*/
alter table [CredentialAttribute]
	add CONSTRAINT [PK_CredentialAttribute] PRIMARY KEY    
(
	[CredentialSetGuid] ,
	[Name] 
)
GO

/* 
	[DiscoveryIpAddressSshResponse]
*/
alter table [DiscoveryIpAddressSshResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressSshResponse] PRIMARY KEY    
(	
	[Address] 
)
GO

/* 
	[DiscoveryDeviceSshData]
*/
alter table [DiscoveryDeviceSshData]
	add CONSTRAINT [PK_DiscoveryDeviceSshData] PRIMARY KEY    
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceSshNetworkAdapter]
*/
alter table [DiscoveryDeviceSshNetworkAdapter]
	add CONSTRAINT [PK_DiscoveryDeviceSshNetworkAdapter] PRIMARY KEY    
(
	[DeviceGuid] ,
	[MacAddress] 
)
GO

/* 
	[DiscoveryDiscoveredIpAddress]
*/
alter table [DiscoveryDiscoveredIpAddress]
	add CONSTRAINT [PK_DiscoveryDiscoveredIpAddress] PRIMARY KEY    
(
	[IpAddress] 
)
GO

/* 
	[DeviceOnboardingIssue]
*/
ALTER TABLE [DeviceOnboardingIssue]
	add	CONSTRAINT [PK_DeviceOnboardingIssue] PRIMARY KEY    
(
	[DeviceOnboardingIssueGuid]
) 
GO


/* 
	[[MwRemoteEndpoint]]
*/
alter TABLE [MwRemoteEndpoint]
	add CONSTRAINT [PK_MwRemoteEndpoint] PRIMARY KEY    
	(
		[MwRemoteEndpointID]
	)
GO


/* 
	[[[PluginConfiguration]]]
*/
ALTER TABLE [PluginConfiguration] ADD 
    CONSTRAINT [PluginConfiguration_PK] PRIMARY KEY   
	 (PluginGuid, [OwnerGuid], [ParameterKey])
go
