﻿alter table AutomatedTaskPackage
	add constraint PK_AutomatedTaskPackage primary key  (AutomatedTaskPackageRevisionGuid)
go

alter table AutomatedTaskPackageNode add 
	constraint PK_AutomatedTaskPackageNode primary key  ( AutomatedTaskPackageNodeGuid)
go

alter table AutomatedTaskPackageNotification
	add constraint 
        PK_AutomatedTaskPackageNotification primary key  ( AutomatedTaskPackageNotificationGuid)
go

alter table AutomatedTaskPackageAction
	add constraint 
        PK_AutomatedTaskPackageAction primary key  ( AutomatedTaskPackageActionGuid)
go

alter table AutomatedTaskPackageScriptParameter add
    constraint PK_AutomatedTaskPackageScriptParameter primary key (AutomatedTaskID, AutomatedTaskPackageNodeGuid,ScriptParameterKey)
go


/* add a new column ScriptRevisionGuid into Script table and mark it as unique */
alter table Script add ScriptRevisionGuid uniqueidentifier   null 
	 ROWGUIDCOL 
go

alter table Script alter column ScriptRevisionGuid uniqueidentifier   NOT null 
go

/*
	potential problem for CE upgrade:
*/
alter table Script
add 
	constraint AK_Script_ScriptRevisionGuid  UNIQUE (ScriptRevisionGuid)
go

/*
Adding ScriptName column to the Script table
Needed for Auto task Package execution alert
*/

ALTER TABLE Script
ADD [ScriptName] [nvarchar](50) NULL
GO
