﻿CREATE TABLE [SdkElement](
    [SdkElementGuid]    uniqueidentifier    NOT NULL,
    [DeviceGuid]        uniqueidentifier    NOT NULL,
    [SdkElementTypeID]  int                 NOT NULL,
    [DateCreated]       datetime            NOT NULL
)
go


CREATE TABLE [SdkElementAttributeData](
    [SdkElementGuid]             uniqueidentifier    NOT NULL,
    [SdkElementAttributeTypeID]  int                 NOT NULL,
	[DateModified]               datetime            NOT NULL
)
go




CREATE TABLE [SdkElementAttributeType](
    [SdkElementAttributeTypeID]  int              not null,
    [SdkElementTypeID]           int              NOT NULL,
    [AttributeTypeName]          nvarchar(128)    NOT NULL,
    [DataType]                   nvarchar(50)      NOT NULL,
    [SqlDataType]                nvarchar(50)      NOT NULL,
    [IsKey]                      bit              CONSTRAINT [SdkElementAttributeType_IsKey_DF] DEFAULT 0 NOT NULL,
    [IsArray]                    bit              CONSTRAINT [SdkElementAttributeType_IsArray_DF] DEFAULT 0 NOT NULL
)
go




CREATE TABLE [SdkElementType](
    [SdkElementTypeID]  int                 not null,
    [ElementTypeName]   nvarchar(128)       NOT NULL,
    [PluginGuid]        uniqueidentifier    NOT NULL,
    [IsSingleInstance]  bit                 CONSTRAINT [SdkElementType_IsSingleInstance_DF] DEFAULT 0 NOT NULL
)
go
