﻿
SET IDENTITY_INSERT [AlertType] ON
GO

INSERT [AlertType] ([AlertTypeID], [AlertTypeName], [IsSelfHealable], [AllowMultipleAlertRules], [IsLegacy90], [AlertingEngine], [AlertSubjectType], [AlertSourceType]) 
		select  300, N'MonitoringFailure', 1, 0, 0, 1, 1, 1
		 where not exists (select * from [AlertType] where AlertTypeID = 300)

GO

/*  
	90-Automation
*/
INSERT [AlertType] ([AlertTypeID], [AlertTypeName], [IsSelfHealable], [AllowMultipleAlertRules], [IsLegacy90], [AlertingEngine], [AlertSubjectType], [AlertSourceType]) 
		select 306, N'AutomatedTaskPackageResult', 0, 0, 0, 1, 4, 1
		 where not exists (select * from [AlertType] where AlertTypeID = 306)
GO

/*  
	10.2
*/
INSERT [AlertType] ([AlertTypeID], [AlertTypeName], [IsSelfHealable], [AllowMultipleAlertRules], [IsLegacy90], [AlertingEngine], [AlertSubjectType], [AlertSourceType]) 
		select  307, N'InvalidCredential', 1, 0, 0, 1, 1, 1
		 where not exists (select * from [AlertType] where AlertTypeID = 307)
GO


SET IDENTITY_INSERT [AlertType] OFF
GO



/******Adding AttributeType records for Syslog Alert Type******/

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  9, 'Facility'			, 'int'		, 1
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'Facility')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  9, 'FacilityOperator', 'int'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'FacilityOperator')

GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  9, 'Message'			, 'string'	, 3
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'Message')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 9, 'MessageOperator'	, 'int'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'MessageOperator')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  9, 'Severity'			, 'int'		, 2
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'Severity')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 9, 'SeverityOperator'	, 'int'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'SeverityOperator')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 9, 'SearchOptions'	, 'string'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'SearchOptions')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 9, 'EventOccurrencesCount'	, 'int'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'EventOccurrencesCount')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 9, 'EventOccurrencesIntervalInMins'	, 'int'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'EventOccurrencesIntervalInMins')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 9, 'FirstEventOccurrence'	, 'DateTime'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'FirstEventOccurrence')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 9, 'LastEventOccurrence'	, 'DateTime'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 9 and AttributeName = 'LastEventOccurrence')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 300, 'Protocol'			, 'string'		,1
 where not exists (select * from AlertAttributeType where AlertTypeID = 300 and AttributeName = 'Protocol')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 300, 'ErrorMessage'			, 'string'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 300 and AttributeName = 'ErrorMessage')
GO

/*  
	90-Automation
Adding Alert Types Attributes for AutomatedTaskPackageResult
NOTE: AutomatedTaskID attribute can be removed when we will do a next reversed merge from Trunk. 
*/

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'PackageResult', 'int'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'PackageResult')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'PackageNotification', 'bool'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'PackageNotification')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'PackageExecutaionResult', 'bool'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'PackageExecutaionResult')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'PackageName', 'string'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'PackageName')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'ScheduledBy', 'string'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'ScheduledBy')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'PackageExecutionCompletedSuccessfully', 'bool'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'PackageExecutionCompletedSuccessfully')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'PackageExecutionNotificationMsg', 'string'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'PackageExecutionNotificationMsg')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'PackageExecutionResultMsg', 'string'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'PackageExecutionResultMsg')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'PackageExecutionResultMsgCutOffFlag', 'bool'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'PackageExecutionResultMsgCutOffFlag')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'AutoTaskSynchronizationGuid', 'string'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'AutoTaskSynchronizationGuid')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'AutoTaskExecutionGuid', 'string'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'AutoTaskExecutionGuid')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'AutoTaskScheduledStartTimeUtc', 'DateTime'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'AutoTaskScheduledStartTimeUtc')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType]) 
select 306, 'DeviceGuid', 'string'
	where not exists (select * from AlertAttributeType where AlertTypeID = 306 and AttributeName = 'DeviceGuid')
GO

/*  
	10.2
*/
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 307, 'CredentialGuid'			, 'string'		, 1
 where not exists (select * from AlertAttributeType where AlertTypeID = 307 and AttributeName = 'CredentialGuid')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 307, 'Type'			, 'string'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 307 and AttributeName = 'Type')
GO

INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 307, 'Message'			, 'string'		, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 307 and AttributeName = 'Message')
GO


/*
[MonitorType]
*/

INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 1, N'Availability', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'Availability')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 2, N'Windows Events', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'Windows Events')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 3, N'Performance Counters', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'Performance Counters')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 4, N'Windows Services', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'Windows Services')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 5, N'Network Services', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'Network Services')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 6, N'SNMP', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'SNMP')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 7, N'SNMP Traps', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'SNMP Traps')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 9, N'Syslog', 1, 0
 where not exists (select * from [MonitorType] where [Name] = 'Syslog')
GO


INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 11, N'Website Down', 2, 1
 where not exists (select * from [MonitorType] where [Name] = 'Website Down')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 12, N'Website Search', 2, 1
 where not exists (select * from [MonitorType] where [Name] = 'Website Search')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 13, N'Website Response', 2, 1
 where not exists (select * from [MonitorType] where [Name] = 'Website Response')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 14, N'Custom Log', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'Custom Log')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 15, N'Patch Status', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'Patch Status')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 16, N'AMT Events', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'AMT Events')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 17, N'Bandwidth', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'Bandwidth')
GO
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 18, N'SCE', 1, 1
 where not exists (select * from [MonitorType] where [Name] = 'SCE')
GO


INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 20, N'AutomatedTask', 4, 1
 where not exists (select * from [MonitorType] where [Name] = 'AutomatedTask')
GO