﻿ALTER TABLE [dbo].[AV_Policy] 
ADD AvmSettingID nvarchar(100) NULL
go

DROP TABLE [dbo].[AVCC_time_servers]
go

ALTER TABLE [dbo].[AVCC_devices]
DROP CONSTRAINT AVCC_devices_AVCC_time_zones_FK;   
GO 

DROP TABLE [dbo].[AVCC_time_zones]
GO

CREATE TABLE [dbo].[AV_VirusChest](
    [DeviceGuid]          uniqueidentifier    NOT NULL,
    [OMRowVersion]        timestamp           NOT NULL,
    [DateCreated]         datetime            NOT NULL,
    [DateModified]        datetime            NOT NULL,
    [VirusChestItemGuid]  uniqueidentifier    NOT NULL,
    [Id]                  nvarchar(100)       NOT NULL,
    [FileName]            nvarchar(1000)      NOT NULL,
    [Location]            nvarchar(1000)      NOT NULL,
    [VirusName]           nvarchar(1000)      NOT NULL,
    [AddedTime]           nvarchar(100)       NOT NULL,
    [Status]              nvarchar(100)       NOT NULL,
    [StatusChangedTime]   nvarchar(100)       NOT NULL,
	CONSTRAINT [AV_VirusChest_AK_SyncGuid] PRIMARY KEY NONCLUSTERED ([VirusChestItemGuid]),
    CONSTRAINT [AV_VirusChest_AK_DeviceGuid_Id_CLUST]  UNIQUE CLUSTERED ([DeviceGuid], [Id])
)
go
ALTER TABLE [AV_CloudCareAgent] 
   ADD[IsPolicyAssignedInAfb] [bit] NOT NULL CONSTRAINT [DF_AV_CloudCareAgent_IsPolicyAssignedInAfb] DEFAULT ((0))
GO

ALTER TABLE [AVCC_device_services] 
ADD include_file_shield bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_rescue_disk bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_webrep bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_exchange bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_sharepoint bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_browser_cleanup bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_secureline bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_safe_zone_browser bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_shredder bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_software_updater bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_wifi_inspector bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_sec_dns bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_password_manager bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_antispam bit NULL
go

ALTER TABLE [AVCC_device_services] 
ADD include_sandbox bit NULL
go

-- MW-6922: Migrate the Threat Detected alert rule to use the new threat type values
UPDATE ARA
 SET Value = CASE Value
 WHEN 5 THEN 0
 WHEN 4 THEN 2
 WHEN 3 THEN 1
 WHEN 2 THEN 3
 ELSE 3
 END
 FROM [dbo].[AlertRuleAttribute] ARA
 INNER JOIN AlertAttributeType AAT ON AAT.AlertAttributeTypeID = ARA.AlertAttributeTypeID
 WHERE AlertTypeID = 302
 AND AttributeName = 'ThreatType'
go