-- Add new MicrosoftDefenderStatus monitor type
INSERT [MonitorType] ([MonitorTypeID], [Name], [MonitorSubjectType], [IsLegacy90])
	select 314, N'MicrosoftDefenderStatus', 1, 0
 where not exists (select * from [MonitorType] where [Name] = 'MicrosoftDefenderStatus')
GO

-- Add new MicrosoftDevenderAvDisabled alert type
SET IDENTITY_INSERT [AlertType] ON
GO

INSERT [AlertType] ([AlertTypeID], [AlertTypeName], [IsSelfHealable], [AllowMultipleAlertRules], [IsLegacy90], [AlertingEngine], [AlertSubjectType], [AlertSourceType]) 
		select 314, N'MicrosoftDefenderStatus', 1, 0, 0, 1, 2, 1
		 where not exists (select * from [AlertType] where AlertTypeID = 314)
GO

INSERT [AlertType] ([AlertTypeID], [AlertTypeName], [IsSelfHealable], [AllowMultipleAlertRules], [IsLegacy90], [AlertingEngine], [AlertSubjectType], [AlertSourceType]) 
		select 315, N'MicrosoftDefenderBehavior', 1, 0, 0, 1, 2, 1
		 where not exists (select * from [AlertType] where AlertTypeID = 315)
GO

SET IDENTITY_INSERT [AlertType] OFF
GO

-- alert rule attribute
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  314, 'Feature'	, 'string'	, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 314 and AttributeName = 'Feature')
GO
-- open alert attribute
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  314, 'Status'	, 'bool'	, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 314 and AttributeName = 'Status')
GO

-- alert rule attribute
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  315, 'Behavior'	, 'string'	, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 315 and AttributeName = 'Behavior')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  315, 'ThresholdInDays'	, 'uint'	, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 315 and AttributeName = 'ThresholdInDays')
GO
-- open alert attribute
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  315, 'ActionAgeInDays'	, 'uint'	, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 315 and AttributeName = 'ActionAgeInDays')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  315, 'ActionLastStartTimeUtc'	, 'DateTime'	, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 315 and AttributeName = 'ActionLastStartTimeUtc')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select  315, 'ActionLastEndTimeUtc'	, 'DateTime'	, NULL
 where not exists (select * from AlertAttributeType where AlertTypeID = 315 and AttributeName = 'ActionLastEndTimeUtc')
GO
