﻿if exists 
(
    select *
      from sys.foreign_keys fk
     where fk.name  = 'FK_MwusPrerequisite_MwusRevision'
       and fk.is_not_trusted = 1
)
begin

	declare @tran int 
	set @tran = @@trancount


	declare @Script nvarchar(1000) 
	set  @Script = '7200_92-SP1_WSUS_142226_ExpressOnly.sql'

	declare @Step   nvarchar(1000) 	   
	set @Step = 'Not trusted FK_MwusPrerequisite_MwusRevision found. Resolving'
    print  @Step

begin try
  
		if @tran = 0    
		BEGIN TRANSACTION   

		set @Step = 'DELETE MwusPrerequisite'
		delete P
		from	MwusPrerequisite P
		where not exists
		(
			select * from MwusRevision r
			  where r.RevisionID = P.RevisionID
	     
		)
	
		set @Step = 'ALTER TABLE [dbo].[MwusPrerequisite]  drop  CONSTRAINT [FK_MwusPrerequisite_MwusRevision]'
		exec(@Step)
	
		set @Step = '
		ALTER TABLE [dbo].[MwusPrerequisite]  WITH CHECK 
			ADD  CONSTRAINT [FK_MwusPrerequisite_MwusRevision] FOREIGN KEY([RevisionID])
				REFERENCES [dbo].[MwusRevision] ([RevisionID])
				'
		exec(@Step)
            
		set @Step = '
		ALTER TABLE [dbo].[MwusPrerequisite] CHECK CONSTRAINT [FK_MwusPrerequisite_MwusRevision]
		'
		exec(@Step)



		if @tran = 0  
			   COMMIT   
		---------------------------------
end try
---------------------
begin catch

    declare @ErrorMessage       nvarchar(max)
    set @ErrorMessage = '[Error in: Script=' +  isnull(@Script,'null') + ' @Step=' + isnull(@Step,'null') + ']' +  + [dbo].[udf_ErrorInfo]()

    if (XACT_STATE() != 0) 
	and @tran = 0  
		rollback transaction

    RaisError (@ErrorMessage,16,255)

end catch
end -- if 
go
